<?php
/* ThemeREX Updater support functions
------------------------------------------------------------------------------- */

// Theme init
if (!function_exists('charity_is_hope_trx_updater_theme_setup')) {
    add_action( 'charity_is_hope_action_before_init_theme', 'charity_is_hope_trx_updater_theme_setup', 1 );
    function charity_is_hope_trx_updater_theme_setup() {
        // Register shortcode in the shortcodes list
        if (is_admin()) {
            add_filter( 'charity_is_hope_filter_required_plugins',				'charity_is_hope_trx_updater_required_plugins' );
        }
    }
}

// Check if Instagram Widget installed and activated
if ( !function_exists( 'charity_is_hope_exists_trx_updater' ) ) {
    function charity_is_hope_exists_trx_updater() {
        return function_exists( 'trx_updater_load_plugin_textdomain' );
    }
}


// Filter to add in the required plugins list
if ( !function_exists( 'charity_is_hope_trx_updater_required_plugins' ) ) {
    function charity_is_hope_trx_updater_required_plugins($list=array()) {
        if (in_array('trx_updater', charity_is_hope_storage_get('required_plugins'))) {
            $path = charity_is_hope_get_file_dir('plugins/install/trx_updater.zip');
            if (file_exists($path)) {
                $list[] = array(
                    'name' 		=> esc_html__('ThemeREX Updater', 'charity-is-hope'),
                    'slug' 		=> 'trx_updater',
                    'source'	=> $path,
                    'version'   => '1.9.2',
                    'required' 	=> false
                );
            }
        }
        return $list;
    }
}