<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('charity_is_hope_elegro_payment_theme_setup')) {
    add_action( 'charity_is_hope_action_before_init_theme', 'charity_is_hope_elegro_payment_theme_setup', 1 );
    function charity_is_hope_elegro_payment_theme_setup() {
        if (is_admin()) {
            add_filter( 'charity_is_hope_filter_required_plugins',		'charity_is_hope_elegro_payment_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'charity_is_hope_elegro_payment_required_plugins' ) ) {
    function charity_is_hope_elegro_payment_required_plugins($list=array()) {
        if (in_array('elegro-payment', (array)charity_is_hope_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('Elegro Payment', 'charity-is-hope'),
                'slug' 		=> 'elegro-payment',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'charity_is_hope_exists_elegro_payment' ) ) {
    function charity_is_hope_exists_elegro_payment() {
        return function_exists('init_Elegro_Payment');
    }
}