<?php

// Register shortcodes in the list

if (function_exists('charity_is_hope_exists_visual_composer') && charity_is_hope_exists_visual_composer() && charity_is_hope_exists_trx_donations()) {
    add_action('charity_is_hope_action_shortcodes_list_vc', 'charity_is_hope_trx_donations_reg_shortcodes_vc');
    add_action('charity_is_hope_action_shortcodes_list', 'charity_is_hope_trx_donations_reg_shortcodes');
}

// Register shortcode in the shortcodes list
if (!function_exists('charity_is_hope_trx_donations_reg_shortcodes')) {
    //Handler of add_filter('charity_is_hope_action_shortcodes_list',	'charity_is_hope_trx_donations_reg_shortcodes');
    function charity_is_hope_trx_donations_reg_shortcodes() {
        if (charity_is_hope_storage_isset('shortcodes')) {

            $plugin = TRX_DONATIONS::get_instance();
            $donations_groups = charity_is_hope_get_list_terms(false, TRX_DONATIONS::TAXONOMY);

            charity_is_hope_sc_map_before('trx_dropcaps', array(

                // Donations form
                "trx_donations_form" => array(
                    "title" => esc_html__("Donations form", 'trx_utils'),
                    "desc" => esc_html__("Insert Donations form", 'trx_utils'),
                    "decorate" => true,
                    "container" => false,
                    "params" => array(
                        "title" => array(
                            "title" => esc_html__("Title", 'trx_utils'),
                            "desc" => esc_html__("Title for the donations form", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "subtitle" => array(
                            "title" => esc_html__("Subtitle", 'trx_utils'),
                            "desc" => esc_html__("Subtitle for the donations form", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "description" => array(
                            "title" => esc_html__("Description", 'trx_utils'),
                            "desc" => esc_html__("Short description for the donations form", 'trx_utils'),
                            "value" => "",
                            "type" => "textarea"
                        ),
                        "align" => array(
                            "title" => esc_html__("Alignment", 'trx_utils'),
                            "desc" => esc_html__("Alignment of the donations form", 'trx_utils'),
                            "divider" => true,
                            "value" => "",
                            "type" => "checklist",
                            "dir" => "horizontal",
                            "options" => charity_is_hope_get_sc_param('align')
                        ),
                        "account" => array(
                            "title" => esc_html__("PayPal account", 'trx_utils'),
                            "desc" => esc_html__("PayPal account's e-mail. If empty - used from Donations settings", 'trx_utils'),
                            "divider" => true,
                            "value" => "",
                            "type" => "text"
                        ),
                        "sandbox" => array(
                            "title" => esc_html__("Sandbox mode", 'trx_utils'),
                            "desc" => esc_html__("Use PayPal sandbox to test payments", 'trx_utils'),
                            "dependency" => array(
                                'account' => array('not_empty')
                            ),
                            "value" => "yes",
                            "type" => "switch",
                            "options" => charity_is_hope_get_sc_param('yes_no')
                        ),
                        "amount" => array(
                            "title" => esc_html__("Default amount", 'trx_utils'),
                            "desc" => esc_html__("Specify amount, initially selected in the form", 'trx_utils'),
                            "dependency" => array(
                                'account' => array('not_empty')
                            ),
                            "value" => 5,
                            "min" => 1,
                            "step" => 5,
                            "type" => "spinner"
                        ),
                        "currency" => array(
                            "title" => esc_html__("Currency", 'trx_utils'),
                            "desc" => esc_html__("Select payment's currency", 'trx_utils'),
                            "dependency" => array(
                                'account' => array('not_empty')
                            ),
                            "divider" => true,
                            "value" => "",
                            "type" => "select",
                            "style" => "list",
                            "multiple" => true,
                            "options" => charity_is_hope_array_merge(array(0 => esc_html__('- Select currency -', 'trx_utils')), $plugin->currency_codes)
                        ),
                        "id" => charity_is_hope_get_sc_param('id'),
                        "class" => charity_is_hope_get_sc_param('class'),
                        "css" => charity_is_hope_get_sc_param('css')
                    )
                ),


                // Donations form
                "trx_donations_list" => array(
                    "title" => esc_html__("Donations list", 'trx_utils'),
                    "desc" => esc_html__("Insert Doantions list", 'trx_utils'),
                    "decorate" => true,
                    "container" => false,
                    "params" => array(
                        "title" => array(
                            "title" => esc_html__("Title", 'trx_utils'),
                            "desc" => esc_html__("Title for the donations list", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "subtitle" => array(
                            "title" => esc_html__("Subtitle", 'trx_utils'),
                            "desc" => esc_html__("Subtitle for the donations list", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "description" => array(
                            "title" => esc_html__("Description", 'trx_utils'),
                            "desc" => esc_html__("Short description for the donations list", 'trx_utils'),
                            "value" => "",
                            "type" => "textarea"
                        ),
                        "link" => array(
                            "title" => esc_html__("Button URL", 'trx_utils'),
                            "desc" => esc_html__("Link URL for the button at the bottom of the block", 'trx_utils'),
                            "divider" => true,
                            "value" => "",
                            "type" => "text"
                        ),
                        "link_caption" => array(
                            "title" => esc_html__("Button caption", 'trx_utils'),
                            "desc" => esc_html__("Caption for the button at the bottom of the block", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "style" => array(
                            "title" => esc_html__("List style", 'trx_utils'),
                            "desc" => esc_html__("Select style to display donations", 'trx_utils'),
                            "value" => "excerpt",
                            "type" => "select",
                            "options" => array(
                                'excerpt' => esc_html__('Excerpt', 'trx_utils'),
                                'extra' => esc_html__('Extra', 'trx_utils')
                            )
                        ),
                        "readmore" => array(
                            "title" => esc_html__("Read more text", 'trx_utils'),
                            "desc" => esc_html__("Text of the 'Read more' link", 'trx_utils'),
                            "value" => esc_html__('Read more', 'trx_utils'),
                            "type" => "hidden"
                        ),
                        "cat" => array(
                            "title" => esc_html__("Categories", 'trx_utils'),
                            "desc" => esc_html__("Select categories (groups) to show donations. If empty - select donations from any category (group) or from IDs list", 'trx_utils'),
                            "divider" => true,
                            "value" => "",
                            "type" => "select",
                            "style" => "list",
                            "multiple" => true,
                            "options" => charity_is_hope_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $donations_groups)
                        ),
                        "count" => array(
                            "title" => esc_html__("Number of donations", 'trx_utils'),
                            "desc" => esc_html__("How many donations will be displayed? If used IDs - this parameter ignored.", 'trx_utils'),
                            "value" => 3,
                            "min" => 1,
                            "max" => 100,
                            "type" => "spinner"
                        ),
                        "columns" => array(
                            "title" => esc_html__("Columns", 'trx_utils'),
                            "desc" => esc_html__("How many columns use to show donations list", 'trx_utils'),
                            "value" => 3,
                            "min" => 2,
                            "max" => 6,
                            "step" => 1,
                            "type" => "spinner"
                        ),
                        "offset" => array(
                            "title" => esc_html__("Offset before select posts", 'trx_utils'),
                            "desc" => esc_html__("Skip posts before select next part.", 'trx_utils'),
                            "dependency" => array(
                                'custom' => array('no')
                            ),
                            "value" => 0,
                            "min" => 0,
                            "type" => "spinner"
                        ),
                        "orderby" => array(
                            "title" => esc_html__("Donadions order by", 'trx_utils'),
                            "desc" => esc_html__("Select desired sorting method", 'trx_utils'),
                            "value" => "date",
                            "type" => "select",
                            "options" => charity_is_hope_get_sc_param('sorting')
                        ),
                        "order" => array(
                            "title" => esc_html__("Donations order", 'trx_utils'),
                            "desc" => esc_html__("Select donations order", 'trx_utils'),
                            "value" => "desc",
                            "type" => "switch",
                            "size" => "big",
                            "options" => charity_is_hope_get_sc_param('ordering')
                        ),
                        "ids" => array(
                            "title" => esc_html__("Donations IDs list", 'trx_utils'),
                            "desc" => esc_html__("Comma separated list of donations ID. If set - parameters above are ignored!", 'trx_utils'),
                            "value" => "",
                            "type" => "text"
                        ),
                        "id" => charity_is_hope_get_sc_param('id'),
                        "class" => charity_is_hope_get_sc_param('class'),
                        "css" => charity_is_hope_get_sc_param('css')
                    )
                )

            ));
        }
    }
}


// Register shortcode in the VC shortcodes list
if (!function_exists('charity_is_hope_trx_donations_reg_shortcodes_vc')) {
    //Handler of add_filter('charity_is_hope_action_shortcodes_list_vc',	'charity_is_hope_trx_donations_reg_shortcodes_vc');
    function charity_is_hope_trx_donations_reg_shortcodes_vc() {

        $plugin = TRX_DONATIONS::get_instance();
        $donations_groups = charity_is_hope_get_list_terms(false, TRX_DONATIONS::TAXONOMY);

        // Donations form
        vc_map( array(
            "base" => "trx_donations_form",
            "name" => esc_html__("Donations form", 'trx_utils'),
            "description" => esc_html__("Insert Donations form", 'trx_utils'),
            "category" => esc_html__('Content', 'trx_utils'),
            'icon' => 'icon_trx_donations_form',
            "class" => "trx_sc_single trx_sc_donations_form",
            "content_element" => true,
            "is_container" => false,
            "show_settings_on_create" => true,
            "params" => array(
                array(
                    "param_name" => "title",
                    "heading" => esc_html__("Title", 'trx_utils'),
                    "description" => esc_html__("Title for the donations form", 'trx_utils'),
                    "admin_label" => true,
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "subtitle",
                    "heading" => esc_html__("Subtitle", 'trx_utils'),
                    "description" => esc_html__("Subtitle for the donations form", 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "description",
                    "heading" => esc_html__("Description", 'trx_utils'),
                    "description" => esc_html__("Description for the donations form", 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textarea"
                ),
                array(
                    "param_name" => "align",
                    "heading" => esc_html__("Alignment", 'trx_utils'),
                    "description" => esc_html__("Alignment of the donations form", 'trx_utils'),
                    "class" => "",
                    "value" => array_flip((array)charity_is_hope_get_sc_param('align')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "account",
                    "heading" => esc_html__("PayPal account", 'trx_utils'),
                    "description" => esc_html__("PayPal account's e-mail. If empty - used from Donations settings", 'trx_utils'),
                    "admin_label" => true,
                    "group" => esc_html__('PayPal', 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "sandbox",
                    "heading" => esc_html__("Sandbox mode", 'trx_utils'),
                    "description" => esc_html__("Use PayPal sandbox to test payments", 'trx_utils'),
                    "admin_label" => true,
                    "group" => esc_html__('PayPal', 'trx_utils'),
                    'dependency' => array(
                        'element' => 'account',
                        'not_empty' => true
                    ),
                    "class" => "",
                    "value" => array("Sandbox mode" => "yes" ),
                    "type" => "checkbox"
                ),
                array(
                    "param_name" => "amount",
                    "heading" => esc_html__("Default amount", 'trx_utils'),
                    "description" => esc_html__("Specify amount, initially selected in the form", 'trx_utils'),
                    "admin_label" => true,
                    "group" => esc_html__('PayPal', 'trx_utils'),
                    "class" => "",
                    "value" => "5",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "currency",
                    "heading" => esc_html__("Currency", 'trx_utils'),
                    "description" => esc_html__("Select payment's currency", 'trx_utils'),
                    "class" => "",
                    "value" => array_flip(charity_is_hope_array_merge(array(0 => esc_html__('- Select currency -', 'trx_utils')), $plugin->currency_codes)),
                    "type" => "dropdown"
                ),
                charity_is_hope_get_vc_param('id'),
                charity_is_hope_get_vc_param('class'),
                charity_is_hope_get_vc_param('css'),
                charity_is_hope_vc_width(),
            )
        ) );

        class WPBakeryShortCode_Trx_Donations_Form extends Charity_Is_Hope_VC_ShortCodeSingle {}



        // Donations list
        vc_map( array(
            "base" => "trx_donations_list",
            "name" => esc_html__("Donations list", 'trx_utils'),
            "description" => esc_html__("Insert Donations list", 'trx_utils'),
            "category" => esc_html__('Content', 'trx_utils'),
            'icon' => 'icon_trx_donations_list',
            "class" => "trx_sc_single trx_sc_donations_list",
            "content_element" => true,
            "is_container" => false,
            "show_settings_on_create" => true,
            "params" => array(
                array(
                    "param_name" => "style",
                    "heading" => esc_html__("List style", 'trx_utils'),
                    "description" => esc_html__("Select style to display donations", 'trx_utils'),
                    "class" => "",
                    "value" => array(
                        esc_html__('Excerpt', 'trx_utils') => 'excerpt',
                        esc_html__('Extra', 'trx_utils') => 'extra'
                    ),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "title",
                    "heading" => esc_html__("Title", 'trx_utils'),
                    "description" => esc_html__("Title for the donations form", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "admin_label" => true,
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "subtitle",
                    "heading" => esc_html__("Subtitle", 'trx_utils'),
                    "description" => esc_html__("Subtitle for the donations form", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "description",
                    "heading" => esc_html__("Description", 'trx_utils'),
                    "description" => esc_html__("Description for the donations form", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textarea"
                ),
                array(
                    "param_name" => "link",
                    "heading" => esc_html__("Button URL", 'trx_utils'),
                    "description" => esc_html__("Link URL for the button at the bottom of the block", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "link_caption",
                    "heading" => esc_html__("Button caption", 'trx_utils'),
                    "description" => esc_html__("Caption for the button at the bottom of the block", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "readmore",
                    "heading" => esc_html__("Read more text", 'trx_utils'),
                    "description" => esc_html__("Text of the 'Read more' link", 'trx_utils'),
                    "group" => esc_html__('Captions', 'trx_utils'),
                    "class" => "",
                    "value" => esc_html__('Read more', 'trx_utils'),
                    "type" => "hidden"
                ),
                array(
                    "param_name" => "cat",
                    "heading" => esc_html__("Categories", 'trx_utils'),
                    "description" => esc_html__("Select category to show donations. If empty - select donations from any category (group) or from IDs list", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "class" => "",
                    "value" => array_flip(charity_is_hope_array_merge(array(0 => esc_html__('- Select category -', 'trx_utils')), $donations_groups)),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "columns",
                    "heading" => esc_html__("Columns", 'trx_utils'),
                    "description" => esc_html__("How many columns use to show donations", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "admin_label" => true,
                    "class" => "",
                    "value" => "3",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "count",
                    "heading" => esc_html__("Number of posts", 'trx_utils'),
                    "description" => esc_html__("How many posts will be displayed? If used IDs - this parameter ignored.", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "class" => "",
                    "value" => "3",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "offset",
                    "heading" => esc_html__("Offset before select posts", 'trx_utils'),
                    "description" => esc_html__("Skip posts before select next part.", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "class" => "",
                    "value" => "0",
                    "type" => "textfield"
                ),
                array(
                    "param_name" => "orderby",
                    "heading" => esc_html__("Post sorting", 'trx_utils'),
                    "description" => esc_html__("Select desired posts sorting method", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "class" => "",
                    "value" => array_flip((array)charity_is_hope_get_sc_param('sorting')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "order",
                    "heading" => esc_html__("Post order", 'trx_utils'),
                    "description" => esc_html__("Select desired posts order", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    "class" => "",
                    "value" => array_flip((array)charity_is_hope_get_sc_param('ordering')),
                    "type" => "dropdown"
                ),
                array(
                    "param_name" => "ids",
                    "heading" => esc_html__("client's IDs list", 'trx_utils'),
                    "description" => esc_html__("Comma separated list of donation's ID. If set - parameters above (category, count, order, etc.)  are ignored!", 'trx_utils'),
                    "group" => esc_html__('Query', 'trx_utils'),
                    'dependency' => array(
                        'element' => 'cats',
                        'is_empty' => true
                    ),
                    "class" => "",
                    "value" => "",
                    "type" => "textfield"
                ),

                charity_is_hope_get_vc_param('id'),
                charity_is_hope_get_vc_param('class'),
                charity_is_hope_get_vc_param('css'),
            )
        ) );

        class WPBakeryShortCode_Trx_Donations_List extends Charity_Is_Hope_VC_ShortCodeSingle {}

    }
}