<?php

/**
 *  Get IP
 */
function seedprod_lite_get_ip() {
	$ip                   = '';
	$http_x_forwarder_for = ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) : null;
	$http_client_ip       = ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_CLIENT_IP'] ) ) : null;
	$remote_addr          = ! empty( $_SERVER['REMOTE_ADDR'] ) ? sanitize_text_field( wp_unslash( $_SERVER['REMOTE_ADDR'] ) ) : null;

	if ( null !== $http_x_forwarder_for && strlen( $http_x_forwarder_for ) > 6 ) {
		$ip = wp_strip_all_tags( $http_x_forwarder_for );
	} elseif ( null !== $http_client_ip && strlen( $http_client_ip ) > 6 ) {
		$ip = wp_strip_all_tags( $http_client_ip );
	} elseif ( null !== $remote_addr && strlen( $remote_addr ) > 6 ) {
		$ip = wp_strip_all_tags( $remote_addr );
	}

	if ( ! $ip ) {
		$ip = '127.0.0.1';
	}

	return wp_strip_all_tags( $ip );
}

/**
 * Update cookie length for bypass url
 */
function seedprod_lite_change_wp_cookie_logout( $expirein ) {
	global $seed_cspv5_bypass_expires;
	if ( ! empty( $seed_cspv5_bypass_expires ) ) {
		return $seed_cspv5_bypass_expires; // Modify the exire cookie
	} else {
		return $expirein;
	}
}


/**
 * Get roles
 */
function seedprod_lite_get_roles() {
	global $wp_roles;

	if ( ! isset( $wp_roles ) ) {
		$wp_roles = new WP_Roles(); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	}
	$roles = $wp_roles->get_names();

	if ( is_multisite() ) {
		$roles['superadmin'] = __( 'SuperAdmin', 'coming-soon' );
	}
	$roles['anyoneloggedin'] = __( 'Anyone Logged In', 'coming-soon' );

	return $roles;
}


/**
* Get Enviroment
*/
function seedprod_lite_is_localhost() {
	// $localhost = array('127.0.0.1','::1');

	// $is_localhost = false;
	// if (in_array($_SERVER['REMOTE_ADDR'], $localhost) || !empty($_GET['debug'])) {
	//     $is_localhost = true;
	// }
	$is_localhost = false;
	if ( defined( 'SEEDPROD_LOCAL_JS' ) ) {
		$is_localhost = true;
	}

	return $is_localhost;
}

/**
 * Get Youtube ID from url.
 *
 * @param string $url Youtube URL.
 * @return string[]|false
 */
function seedprod_lite_youtube_id_from_url( $url ) {
	$pattern =
		'%^# Match any youtube URL
        (?:https?://)?  # Optional scheme. Either http or https
        (?:www\.)?      # Optional www subdomain
        (?:             # Group host alternatives
          youtu\.be/    # Either youtu.be,
        | youtube\.com  # or youtube.com
          (?:           # Group path alternatives
            /embed/     # Either /embed/
          | /v/         # or /v/
          | /watch\?v=  # or /watch\?v=
          )             # End path alternatives.
        )               # End host alternatives.
        ([\w-]{10,12})  # Allow 10-12 for 11 char youtube id.
        $%x';
	$result  = preg_match( $pattern, $url, $matches );
	if ( false !== $result ) {
		if ( isset( $matches[1] ) ) {
			return $matches[1];
		}
	}
	return false;
}

/**
* Entry Options
*/
function seedprod_lite_block_options() {
	$block_options = array(
		array(
			'name'   => __( 'Column', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'layout',
			'type'   => 'column',
			'id'     => 1,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6  sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M4 5v13h17V5H4zm10 2v9h-3V7h3zM6 7h3v9H6V7zm13 9h-3V7h3v9z"/></svg>',
		),
		// array('name'=>__('2 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'2-col', 'id'=>2),
		// array('name'=>__('3 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'3-col', 'id'=>3),
		// array('name'=>__('4 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'4-col', 'id'=>4),
		// array('name'=>__('5 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'5-col', 'id'=>5),
		// array('name'=>__('6 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'6-col', 'id'=>6),
		// array('name'=>__('Left Sidebar','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'left-sidebar', 'id'=>7),
		// array('name'=>__('Right Sidebar','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'right-sidebar', 'id'=>8),

		// array('name'=>__('6 Column','coming-soon'),'is_pro'=> false ,'cat'=>'layout','type'=>'6-col', 'id'=>6),

		array(
			'name'   => __( 'Headline', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'header',
			'id'     => 9,
			'icon'   => '<svg viewBox="0 0 12 17" class="sp-w-14px  sp-fill-current sp-pb-2" xmlns="http://www.w3.org/2000/svg">
        <path d="M9 0.800049V7.04005H3V0.800049H0V16.4H3V10.16H9V16.4H12V0.800049H9Z"/>
        </svg>
        ',
		),
		//array('name'=>__('Sub Headline','coming-soon'),'is_pro'=> false,'cat'=>'common','type'=>'sub-header', 'id'=>10, 'icon' => 'fas fa-heading'),
		array(
			'name'   => __( 'Text', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'text',
			'id'     => 11,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" class="sp-w-6 sp-fill-current "><rect x="0" fill="none"/><g><path d="M15 2H7.54c-.83 0-1.59.2-2.28.6-.7.41-1.25.96-1.65 1.65C3.2 4.94 3 5.7 3 6.52s.2 1.58.61 2.27c.4.69.95 1.24 1.65 1.64.69.41 1.45.61 2.28.61h.43V17c0 .27.1.51.29.71.2.19.44.29.71.29.28 0 .51-.1.71-.29.2-.2.3-.44.3-.71V5c0-.27.09-.51.29-.71.2-.19.44-.29.71-.29s.51.1.71.29c.19.2.29.44.29.71v12c0 .27.1.51.3.71.2.19.43.29.71.29.27 0 .51-.1.71-.29.19-.2.29-.44.29-.71V4H15c.27 0 .5-.1.7-.3.2-.19.3-.43.3-.7s-.1-.51-.3-.71C15.5 2.1 15.27 2 15 2z"/></g></svg>',
		),
		array(
			'name'   => __( 'List', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'bullet-list',
			'id'     => 12,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current"><g fill="none"><path d="M0 0h24v24H0V0z"/><path d="M0 0h24v24H0V0z" opacity=".87"/></g><path d="M3 13h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7zm-4 6h2v-2H3v2zm0 4h2v-2H3v2zm0-8h2V7H3v2zm4 4h14v-2H7v2zm0 4h14v-2H7v2zM7 7v2h14V7H7z"/></svg>',
		),
		array(
			'name'   => __( 'Button', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'button',
			'id'     => 13,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" class="sp-w-6 sp-fill-current "  viewBox="0 0 24 24" ><g><rect fill="none" /></g><g><g><path d="M18.19,12.44l-3.24-1.62c1.29-1,2.12-2.56,2.12-4.32c0-3.03-2.47-5.5-5.5-5.5s-5.5,2.47-5.5,5.5c0,2.13,1.22,3.98,3,4.89 v3.26c-2.15-0.46-2.02-0.44-2.26-0.44c-0.53,0-1.03,0.21-1.41,0.59L4,16.22l5.09,5.09C9.52,21.75,10.12,22,10.74,22h6.3 c0.98,0,1.81-0.7,1.97-1.67l0.8-4.71C20.03,14.32,19.38,13.04,18.19,12.44z M17.84,15.29L17.04,20h-6.3 c-0.09,0-0.17-0.04-0.24-0.1l-3.68-3.68l4.25,0.89V6.5c0-0.28,0.22-0.5,0.5-0.5c0.28,0,0.5,0.22,0.5,0.5v6h1.76l3.46,1.73 C17.69,14.43,17.91,14.86,17.84,15.29z M8.07,6.5c0-1.93,1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5c0,0.95-0.38,1.81-1,2.44V6.5 c0-1.38-1.12-2.5-2.5-2.5c-1.38,0-2.5,1.12-2.5,2.5v2.44C8.45,8.31,8.07,7.45,8.07,6.5z"/></g></g></svg>',
		),
		array(
			'name'   => __( 'Image', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'image',
			'id'     => 14,
			'icon'   => '<svg  class="sp-w-6 sp-fill-current " xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 5v14H5V5h14m0-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4.86 8.86l-3 3.87L9 13.14 6 17h12l-3.86-5.14z"/></svg>',
		),
		array(
			'name'   => __( 'Video', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'video',
			'id'     => 15,
			'icon'   => '<svg  class="sp-w-6 sp-fill-current " xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" ><path d="M0 0h24v24H0V0z" fill="none"/><path d="M15 8v8H5V8h10m1-2H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4V7c0-.55-.45-1-1-1z"/></svg>',
		),
		array(
			'name'   => __( 'Divider', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'divider',
			'id'     => 17,
			'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><g><rect fill="none" /></g><g><g><g><path d="M20,9H4v2h16V9z M4,15h16v-2H4V15z"/></g></g></g></svg>',
		),
		array(
			'name'   => __( 'Spacer', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'common',
			'type'   => 'spacer',
			'id'     => 24,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current sp-transform sp-rotate-90" ><path d="M0 0h24v24H0z" fill="none"/><path d="M7.77 6.76L6.23 5.48.82 12l5.41 6.52 1.54-1.28L3.42 12l4.35-5.24zM7 13h2v-2H7v2zm10-2h-2v2h2v-2zm-6 2h2v-2h-2v2zm6.77-7.52l-1.54 1.28L20.58 12l-4.35 5.24 1.54 1.28L23.18 12l-5.41-6.52z"/></svg>',
		),

		array(
			'name'   => __( 'Giveaway', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'adv',
			'type'   => 'giveaway',
			'id'     => 32,
			'icon'   => '<svg class="sp-w-5 sp-fill-current " viewBox="0 0 394 416" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
				<path d="M161.294,281.219 C151.445,281.219 143.462,289.202 143.462,299.049 C143.462,308.896 151.445,316.878 161.294,316.878 C171.139,316.878 179.122,308.896 179.122,299.049 C179.122,289.202 171.139,281.219 161.294,281.219 Z M232.979,281.219 C223.132,281.219 215.149,289.202 215.149,299.049 C215.149,308.896 223.132,316.878 232.979,316.878 C242.826,316.878 250.806,308.896 250.806,299.049 C250.806,289.202 242.826,281.219 232.979,281.219 Z M32.608,123.757 C30.714,158.655 31.726,255.445 32.608,292.617 C32.68,295.618 34.565,297.889 37.042,299.527 C58.017,313.458 79.698,326.395 101.835,338.541 C98.77,308.445 98.261,273.714 107.731,252.542 C111.467,244.191 119.577,237.434 130.383,232.272 C111.019,204.919 98.751,172.762 95.699,143.461 C91.243,100.685 159.191,80.829 161.091,113.506 C163.202,149.839 167.026,185.74 173.214,221.056 C180.966,220.166 188.963,219.72 196.962,219.708 C205.077,219.704 213.195,220.154 221.06,221.056 C227.245,185.74 231.071,149.839 233.18,113.506 C235.079,80.829 303.03,100.685 298.574,143.461 C295.523,172.762 283.254,204.919 263.891,232.272 C274.694,237.434 282.806,244.191 286.542,252.542 C295.99,273.665 295.504,308.286 292.458,338.332 C314.469,326.252 336.023,313.381 356.885,299.527 C359.356,297.889 361.245,295.618 361.316,292.617 C362.199,255.445 363.21,158.655 361.316,123.757 C361.008,120.766 359.356,118.487 356.885,116.846 C307.739,84.205 254.723,57.023 201.025,32.736 C199.667,32.123 198.314,31.818 196.962,31.818 C195.61,31.818 194.257,32.123 192.902,32.736 C139.201,57.023 86.185,84.205 37.042,116.846 C34.565,118.487 32.913,120.766 32.608,123.757 Z M1.328,120.554 C2.595,108.178 9.333,97.499 19.644,90.651 C70.294,57.012 124.602,29.116 179.943,4.087 C190.893,-0.864 203.032,-0.864 213.981,4.087 C269.323,29.116 323.628,57.012 374.28,90.651 C384.913,97.713 392.019,109.24 392.712,122.052 C394.273,150.787 393.913,180.541 393.792,209.337 C393.674,237.33 393.416,265.374 392.75,293.359 C392.432,306.785 385.326,318.385 374.28,325.719 C323.628,359.361 269.323,387.262 213.981,412.29 C203.032,417.237 190.893,417.237 179.943,412.29 C124.602,387.262 70.294,359.361 19.644,325.719 C8.596,318.385 1.493,306.785 1.174,293.359 C0.509,265.374 0.248,237.33 0.132,209.337 C0.047,189.407 -0.464,137.991 1.328,120.554 L1.328,120.554 Z" id="Fill-5"></path>
        </svg>',
		),

		array(
			'name'   => __( 'Contact Form', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'adv',
			'type'   => 'contact-form',
			'id'     => 23,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="sp-w-5 sp-fill-current "><path fill="currentColor" d="M448 75.2v361.7c0 24.3-19 43.2-43.2 43.2H43.2C19.3 480 0 461.4 0 436.8V75.2C0 51.1 18.8 32 43.2 32h361.7c24 0 43.1 18.8 43.1 43.2zm-37.3 361.6V75.2c0-3-2.6-5.8-5.8-5.8h-9.3L285.3 144 224 94.1 162.8 144 52.5 69.3h-9.3c-3.2 0-5.8 2.8-5.8 5.8v361.7c0 3 2.6 5.8 5.8 5.8h361.7c3.2.1 5.8-2.7 5.8-5.8zM150.2 186v37H76.7v-37h73.5zm0 74.4v37.3H76.7v-37.3h73.5zm11.1-147.3l54-43.7H96.8l64.5 43.7zm210 72.9v37h-196v-37h196zm0 74.4v37.3h-196v-37.3h196zm-84.6-147.3l64.5-43.7H232.8l53.9 43.7zM371.3 335v37.3h-99.4V335h99.4z"></path></svg>',
		),

		array(
			'name'   => __( 'Optin Form', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'optin-form',
			'id'     => 22,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6zm-2 0l-8 4.99L4 6h16zm0 12H4V8l8 5 8-5v10z"/></svg>',
		),

		array(
			'name'   => __( 'Countdown', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'countdown',
			'id'     => 16,
			'icon'   => '
<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M15.07 1.01h-6v2h6v-2zm-4 13h2v-6h-2v6zm8.03-6.62l1.42-1.42c-.43-.51-.9-.99-1.41-1.41l-1.42 1.42C16.14 4.74 14.19 4 12.07 4c-4.97 0-9 4.03-9 9s4.02 9 9 9 9-4.03 9-9c0-2.11-.74-4.06-1.97-5.61zm-7.03 12.62c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z"/></svg>',
		),
		array(
			'name'   => __( 'Social Profiles', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'social-profiles',
			'id'     => 18,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M9 13.75c-2.34 0-7 1.17-7 3.5V19h14v-1.75c0-2.33-4.66-3.5-7-3.5zM4.34 17c.84-.58 2.87-1.25 4.66-1.25s3.82.67 4.66 1.25H4.34zM9 12c1.93 0 3.5-1.57 3.5-3.5S10.93 5 9 5 5.5 6.57 5.5 8.5 7.07 12 9 12zm0-5c.83 0 1.5.67 1.5 1.5S9.83 10 9 10s-1.5-.67-1.5-1.5S8.17 7 9 7zm7.04 6.81c1.16.84 1.96 1.96 1.96 3.44V19h4v-1.75c0-2.02-3.5-3.17-5.96-3.44zM15 12c1.93 0 3.5-1.57 3.5-3.5S16.93 5 15 5c-.54 0-1.04.13-1.5.35.63.89 1 1.98 1 3.15s-.37 2.26-1 3.15c.46.22.96.35 1.5.35z"/></svg>',
		),
		array(
			'name'   => __( 'Social Sharing', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'social-sharing',
			'id'     => 19,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M18 16.08c-.76 0-1.44.3-1.96.77L8.91 12.7c.05-.23.09-.46.09-.7s-.04-.47-.09-.7l7.05-4.11c.54.5 1.25.81 2.04.81 1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3c0 .24.04.47.09.7L8.04 9.81C7.5 9.31 6.79 9 6 9c-1.66 0-3 1.34-3 3s1.34 3 3 3c.79 0 1.5-.31 2.04-.81l7.12 4.16c-.05.21-.08.43-.08.65 0 1.61 1.31 2.92 2.92 2.92s2.92-1.31 2.92-2.92c0-1.61-1.31-2.92-2.92-2.92zM18 4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zM6 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm12 7.02c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z"/></svg>',
		),
		//array('name'=>__('Form','coming-soon'),'is_pro'=> false  ,'cat'=>'adv','type'=>'form', 'id'=>25, 'icon' => 'far fa-envelope'),
		array(
			'name'   => __( 'Animated Headline', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'animatedheadline',
			'id'     => 11,
			'icon'   => '<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M6.92423 2V22.4525H10.5335V13.297H20.1582V22.4525H23.7675V2H20.1582V10.4216H10.5335V2H6.92423ZM23.178 27.8784C23.3427 28.0179 23.5516 28.0947 23.7675 28.095C23.9501 28.0753 24.1223 28.0004 24.2612 27.8803C24.4001 27.7602 24.499 27.6006 24.5448 27.4227C24.5905 27.2449 24.5809 27.0573 24.5173 26.8851C24.4536 26.7128 24.339 26.5641 24.1886 26.4588L22.1674 24.7263C21.7878 24.3938 21.3004 24.2105 20.7959 24.2105C20.2913 24.2105 19.8039 24.3938 19.4243 24.7263L18.2212 25.785C18.1653 25.831 18.0951 25.8561 18.0227 25.8561C17.9503 25.8561 17.8802 25.831 17.8242 25.785L16.6211 24.7263C16.2416 24.3938 15.7542 24.2105 15.2496 24.2105C14.745 24.2105 14.2576 24.3938 13.8781 24.7263L12.675 25.785C12.6191 25.831 12.5489 25.8561 12.4765 25.8561C12.4041 25.8561 12.3339 25.831 12.278 25.785L11.0749 24.7263C10.6954 24.3938 10.208 24.2105 9.70337 24.2105C9.19879 24.2105 8.71139 24.3938 8.33185 24.7263L6.31067 26.4588C6.12879 26.6183 6.01774 26.8436 6.00195 27.085C5.98615 27.3264 6.06691 27.5642 6.22645 27.7461C6.38599 27.928 6.61124 28.039 6.85266 28.0548C7.09408 28.0706 7.33188 27.9898 7.51375 27.8303L9.67931 26.1339C9.73527 26.088 9.80542 26.0629 9.87782 26.0629C9.95022 26.0629 10.0204 26.088 10.0763 26.1339L11.2794 27.2047C11.6623 27.5302 12.1484 27.7089 12.6509 27.7089C13.1535 27.7089 13.6396 27.5302 14.0225 27.2047L15.2256 26.1339C15.2785 26.0866 15.347 26.0604 15.418 26.0604C15.4891 26.0604 15.5576 26.0866 15.6105 26.1339L16.8136 27.2047C17.1965 27.5302 17.6826 27.7089 18.1851 27.7089C18.6877 27.7089 19.1738 27.5302 19.5567 27.2047L20.7598 26.1339C20.8157 26.088 20.8859 26.0629 20.9583 26.0629C21.0307 26.0629 21.1008 26.088 21.1568 26.1339L23.178 27.8784Z" />
		</svg>',
		),
		array(
			'name'   => __( 'Progress Bar', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'progress-bar',
			'id'     => 24,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24"  class="sp-w-6 sp-fill-current sp-transform sp-rotate-90"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M5 9.2h3V19H5V9.2zM10.6 5h2.8v14h-2.8V5zm5.6 8H19v6h-2.8v-6z"/></svg>',
		),
		array(
			'name'   => __( 'Icon', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'icon',
			'id'     => 24,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M16.5 3c-1.74 0-3.41.81-4.5 2.09C10.91 3.81 9.24 3 7.5 3 4.42 3 2 5.42 2 8.5c0 3.78 3.4 6.86 8.55 11.54L12 21.35l1.45-1.32C18.6 15.36 22 12.28 22 8.5 22 5.42 19.58 3 16.5 3zm-4.4 15.55l-.1.1-.1-.1C7.14 14.24 4 11.39 4 8.5 4 6.5 5.5 5 7.5 5c1.54 0 3.04.99 3.57 2.36h1.87C13.46 5.99 14.96 5 16.5 5c2 0 3.5 1.5 3.5 3.5 0 2.89-3.14 5.74-7.9 10.05z"/></svg>',
		),

		array(
			'name'   => __( 'Testimonials', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'testimonial',
			'id'     => 34,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 14H6l-2 2V4h16v12z"/></svg>',
		),

		array(
			'name'   => __( 'Image Carousel', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'imagecarousel',
			'id'     => 45,
			'icon'   => '
			<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M6.10999 4H23.89C24.1959 4.01301 24.4843 4.14646 24.6923 4.37126C24.9002 4.59606 25.0108 4.89397 25 5.2V20.76C25.0108 21.066 24.9002 21.3639 24.6923 21.5887C24.4843 21.8135 24.1959 21.947 23.89 21.96H6.10999C5.80405 21.947 5.51565 21.8135 5.30771 21.5887C5.09977 21.3639 4.98916 21.066 5 20.76V5.2C4.98916 4.89397 5.09977 4.59606 5.30771 4.37126C5.51565 4.14646 5.80405 4.01301 6.10999 4ZM22.78 6.4H7.21999V17.2L12.66 9.38L17.22 14.31L22.78 8.31V6.4ZM12.9 13.03L8.32999 19.6H22.78V11.7L17.22 17.7L12.9 13.03ZM16 24.52C16 25.0723 15.5523 25.52 15 25.52C14.4477 25.52 14 25.0723 14 24.52C14 23.9677 14.4477 23.52 15 23.52C15.5523 23.52 16 23.9677 16 24.52ZM11 25.52C11.5523 25.52 12 25.0723 12 24.52C12 23.9677 11.5523 23.52 11 23.52C10.4477 23.52 10 23.9677 10 24.52C10 25.0723 10.4477 25.52 11 25.52ZM20 24.52C20 25.0723 19.5523 25.52 19 25.52C18.4477 25.52 18 25.0723 18 24.52C18 23.9677 18.4477 23.52 19 23.52C19.5523 23.52 20 23.9677 20 24.52ZM26.85 11.52L29 13.67L26.85 15.82V11.52ZM1 13.67L3.15 15.82V11.52L1 13.67Z" />
			</svg>
			',
		),

		array(
			'name'   => __( 'Image Box', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'feature',
			'id'     => 24,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM4 6h9v7H4z"/></svg>',
		),

		array(
			'name'   => __( 'Icon Box', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'iconfeature',
			'id'     => 26,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H3V5h18v14zM5 10h9v2H5zm0-3h9v2H5z"/></svg>',
		),

		array(
			'name'   => __( 'Nav Menu', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'nav',
			'id'     => 25,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0z" fill="none"/><path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"/></svg>',
		),
		array(
			'name'   => __( 'Pricing Table', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'pricingtable',
			'id'     => 44,
			'icon'   => '<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M21 26.5V3H9.5C9.36739 3 9.24021 3.05268 9.14645 3.14645C9.05268 3.24021 9 3.36739 9 3.5V26.5C9 26.6326 9.05268 26.7598 9.14645 26.8536C9.24021 26.9473 9.36739 27 9.5 27H20.5C20.6326 27 20.7598 26.9473 20.8536 26.8536C20.9473 26.7598 21 26.6326 21 26.5ZM8 1H22C22.2652 1 22.5196 1.10536 22.7071 1.29289C22.8946 1.48043 23 1.73478 23 2V3H27.17C27.6776 3.02336 28.1552 3.24698 28.4983 3.62186C28.8413 3.99675 29.0217 4.49233 29 5V25C29.0217 25.5077 28.8413 26.0033 28.4983 26.3781C28.1552 26.753 27.6776 26.9766 27.17 27H23V28C23 28.2652 22.8946 28.5196 22.7071 28.7071C22.5196 28.8946 22.2652 29 22 29H8C7.73478 29 7.48043 28.8946 7.29289 28.7071C7.10536 28.5196 7 28.2652 7 28V27H2.83C2.3224 26.9766 1.84476 26.753 1.50174 26.3781C1.15871 26.0033 0.978291 25.5077 1 25V5C0.978291 4.49233 1.15871 3.99675 1.50174 3.62186C1.84476 3.24698 2.3224 3.02336 2.83 3H7V2C7 1.73478 7.10536 1.48043 7.29289 1.29289C7.48043 1.10536 7.73478 1 8 1ZM7 5V25H3.51C3.37739 25 3.25022 24.9473 3.15645 24.8536C3.06268 24.7598 3.01 24.6326 3.01 24.5V5.5C3.01 5.36739 3.06268 5.24021 3.15645 5.14645C3.25022 5.05268 3.37739 5 3.51 5H7ZM23 25H26.49C26.6226 25 26.7498 24.9473 26.8436 24.8536C26.9373 24.7598 26.99 24.6326 26.99 24.5V5.5C26.99 5.36739 26.9373 5.24021 26.8436 5.14645C26.7498 5.05268 26.6226 5 26.49 5H23V25ZM14.52 6.38H15.52V7.52C15.746 7.56137 15.9697 7.61478 16.19 7.68C16.426 7.74892 16.6514 7.84986 16.86 7.98L16.45 9.08C16.2355 8.96937 16.0112 8.87897 15.78 8.81001C15.5278 8.72993 15.2646 8.68945 15 8.69C14.807 8.68258 14.616 8.7312 14.45 8.83C14.3798 8.87052 14.3216 8.92884 14.2812 8.99908C14.2408 9.06932 14.2197 9.14898 14.22 9.23C14.2191 9.30637 14.2369 9.38179 14.2717 9.44975C14.3066 9.5177 14.3575 9.57614 14.42 9.62C14.6283 9.75956 14.858 9.86427 15.1 9.93001L15.59 10.1C16.0513 10.2242 16.4676 10.4774 16.79 10.83C17.0646 11.1658 17.2146 11.5862 17.2146 12.02C17.2146 12.4538 17.0646 12.8742 16.79 13.21C16.4155 13.5952 15.9151 13.833 15.38 13.88V15.09H14.38V13.9C13.7692 13.844 13.1818 13.6379 12.67 13.3L13.18 12.23C13.4086 12.3927 13.6618 12.5176 13.93 12.6C14.1774 12.6701 14.4329 12.7071 14.69 12.71C14.9501 12.7383 15.2119 12.6746 15.43 12.53C15.4872 12.4797 15.5335 12.4184 15.5662 12.3496C15.5989 12.2808 15.6172 12.2061 15.62 12.13C15.6195 12.0569 15.6042 11.9846 15.575 11.9176C15.5458 11.8505 15.5033 11.7901 15.45 11.74C15.2683 11.5906 15.057 11.4815 14.83 11.42L14.29 11.24C14.0692 11.1687 13.8551 11.0784 13.65 10.97C13.4589 10.8655 13.2838 10.7342 13.13 10.58C12.981 10.4249 12.8593 10.2457 12.77 10.05C12.6799 9.83131 12.6357 9.59647 12.64 9.36C12.634 9.1127 12.6818 8.86705 12.78 8.64001C12.8745 8.42552 13.0104 8.23182 13.18 8.07001C13.3504 7.90178 13.5551 7.77219 13.78 7.69C14.0206 7.59946 14.2734 7.54553 14.53 7.53L14.52 6.38ZM10.5 17H19.5C19.7761 17 20 17.2239 20 17.5C20 17.7761 19.7761 18 19.5 18H10.5C10.2239 18 10 17.7761 10 17.5C10 17.2239 10.2239 17 10.5 17ZM19.5 20H10.5C10.2239 20 10 20.2239 10 20.5C10 20.7761 10.2239 21 10.5 21H19.5C19.7761 21 20 20.7761 20 20.5C20 20.2239 19.7761 20 19.5 20ZM10.5 23H19.5C19.7761 23 20 23.2239 20 23.5C20 23.7761 19.7761 24 19.5 24H10.5C10.2239 24 10 23.7761 10 23.5C10 23.2239 10.2239 23 10.5 23Z" />
			</svg>
		',
		),

		array(
			'name'   => __( 'Anchor', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'anchor',
			'id'     => 30,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current" ><path d="M17,15l1.55,1.55c-0.96,1.69-3.33,3.04-5.55,3.37V11h3V9h-3V7.82C14.16,7.4,15,6.3,15,5c0-1.65-1.35-3-3-3S9,3.35,9,5 c0,1.3,0.84,2.4,2,2.82V9H8v2h3v8.92c-2.22-0.33-4.59-1.68-5.55-3.37L7,15l-4-3v3c0,3.88,4.92,7,9,7s9-3.12,9-7v-3L17,15z M12,4 c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,4,12,4z"/></g></svg>',
		),

		array(
			'name'   => __( 'Star Rating', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'starrating',
			'id'     => 31,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M12 7.13l.97 2.29.47 1.11 1.2.1 2.47.21-1.88 1.63-.91.79.27 1.18.56 2.41-2.12-1.28-1.03-.64-1.03.62-2.12 1.28.56-2.41.27-1.18-.91-.79-1.88-1.63 2.47-.21 1.2-.1.47-1.11.97-2.27M12 2L9.19 8.63 2 9.24l5.46 4.73L5.82 21 12 17.27 18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2z"/></svg>',
		),

		array(
			'name'   => __( 'Accordion', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'accordion',
			'id'     => 34,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M21 18H2v2h19v-2zm-2-8v4H4v-4h15m1-2H3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1h17c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm1-4H2v2h19V4z"/></svg>',
		),

		array(
			'name'   => __( 'Shortcode', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'shortcode',
			'id'     => 21,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="sp-w-6 sp-fill-current"><path d="M256 8C119.3 8 8 119.2 8 256c0 136.7 111.3 248 248 248s248-111.3 248-248C504 119.2 392.7 8 256 8zM33 256c0-32.3 6.9-63 19.3-90.7l106.4 291.4C84.3 420.5 33 344.2 33 256zm223 223c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2L200.6 393l-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3C109.6 73 178.1 33 256 33c58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"/></svg>',
		),

		array(
			'name'   => __( 'Login Form', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'login',
			'id'     => 33,
			'icon'   => '
		<svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " enable-background="new 0 0 24 24" height="24" viewBox="0 0 24 24" width="24"><g><rect fill="none" /></g><g><path d="M11,7L9.6,8.4l2.6,2.6H2v2h10.2l-2.6,2.6L11,17l5-5L11,7z M20,19h-8v2h8c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2h-8v2h8V19z"/></g></svg>',
		),

		array(
			'name'   => __( 'Google Maps', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'googlemaps',
			'id'     => 50,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " enable-background="new 0 0 30 30" viewBox="0 0 30 30" ><g><rect fill="none" /></g><g><path d="M26.3333 3L26.12 3.04L19 5.8L11 3L3.48 5.53333C3.2 5.62667 3 5.86667 3 6.17333V26.3333C3 26.7067 3.29333 27 3.66667 27L3.88 26.96L11 24.2L19 27L26.52 24.4667C26.8 24.3733 27 24.1333 27 23.8267V3.66667C27 3.29333 26.7067 3 26.3333 3ZM19 24.3333L11 21.52V5.66667L19 8.48V24.3333Z"/></g></svg>',
		),

		array(

			'name'   => __( 'Search Form', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'searchform',
			'id'     => 52,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" class="sp-w-6 sp-fill-current " viewBox="0 0 24 24" ><path d="M0 0h24v24H0V0z" fill="none"></path><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"></path></svg>',
		),

		array(
			'name'   => __( 'Facebook Like', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'facebooklike',
			'id'     => 35,
			'icon'   => '
				<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path d="M11.66 14.44H7.02C7.00895 14.44 7 14.449 7 14.46V22.5C7 22.511 7.00895 22.52 7.02 22.52H11.66C11.671 22.52 11.68 22.511 11.68 22.5V14.46C11.68 14.449 11.671 14.44 11.66 14.44Z" />
				<path d="M23 16.58C23.0003 16.3506 22.9544 16.1235 22.865 15.9121C22.7757 15.7008 22.6448 15.5097 22.48 15.35C22.7099 15.0664 22.84 14.715 22.85 14.35C22.8473 13.9028 22.6676 13.4749 22.35 13.16C22.0146 12.8194 21.558 12.6252 21.08 12.62H17.35L17.59 11C17.6217 10.8015 17.6384 10.601 17.64 10.4C17.64 8.88001 16.64 7.10001 15.27 7.10001C14.9031 7.10899 14.5503 7.24306 14.27 7.48001L14.13 7.60001L14.32 10.13C14.3352 10.2361 14.3352 10.3439 14.32 10.45C14.2922 10.5545 14.252 10.6552 14.2 10.75L12.2 14.52L12.13 14.58C12.1036 14.4113 12.0172 14.2579 11.8868 14.1477C11.7564 14.0375 11.5907 13.9779 11.42 13.98H7.37C7.27592 13.9787 7.18252 13.9961 7.09522 14.0312C7.00792 14.0662 6.92847 14.1183 6.86148 14.1844C6.79448 14.2505 6.74129 14.3292 6.70499 14.416C6.66868 14.5028 6.64999 14.5959 6.65 14.69V22.13C6.64999 22.2241 6.66868 22.3172 6.70499 22.404C6.74129 22.4908 6.79448 22.5696 6.86148 22.6356C6.92847 22.7017 7.00792 22.7538 7.09522 22.7889C7.18252 22.8239 7.27592 22.8413 7.37 22.84H11.31C11.4983 22.84 11.6789 22.7652 11.812 22.6321C11.9452 22.4989 12.02 22.3183 12.02 22.13V21.75C12.5073 22.1373 13.1077 22.3549 13.73 22.37H19.67C20.1027 22.3498 20.5116 22.1662 20.8141 21.8563C21.1167 21.5463 21.2903 21.1331 21.3 20.7C21.3153 20.5638 21.3153 20.4262 21.3 20.29C21.6037 20.1543 21.8605 19.932 22.0384 19.6509C22.2163 19.3698 22.3073 19.0425 22.3 18.71C22.3024 18.4834 22.2582 18.2587 22.17 18.05C22.4224 17.8963 22.6312 17.6804 22.7765 17.4231C22.9218 17.1658 22.9987 16.8755 23 16.58ZM11.33 22.16H7.37V14.72H11.31V22.16H11.33ZM21.57 17.56L21.1 17.7L21.39 18.1C21.5255 18.2746 21.5993 18.4891 21.6 18.71C21.6027 18.9512 21.5182 19.1852 21.362 19.369C21.2058 19.5527 20.9885 19.6738 20.75 19.71L20.28 19.79L20.5 20.22C20.5745 20.3653 20.6123 20.5267 20.61 20.69C20.61 20.9552 20.5046 21.2096 20.3171 21.3971C20.1296 21.5846 19.8752 21.69 19.61 21.69H13.74C13.2818 21.6743 12.8405 21.5132 12.48 21.23C12.3821 21.1426 12.2707 21.0716 12.15 21.02L12 21V15.52L12.62 14.99L14.7 11.13C14.7912 10.9814 14.8586 10.8194 14.9 10.65C14.9463 10.474 14.9632 10.2915 14.95 10.11L14.8 8.00001C14.9435 7.91855 15.105 7.87389 15.27 7.87001C16.17 7.87001 16.94 9.31001 16.94 10.48C16.9502 10.6432 16.9502 10.8068 16.94 10.97L16.57 13.31H21.09C21.3832 13.3137 21.6632 13.4322 21.87 13.64C21.9645 13.7326 22.0397 13.8431 22.0912 13.9649C22.1427 14.0868 22.1695 14.2177 22.17 14.35C22.1652 14.5068 22.126 14.6607 22.0552 14.8006C21.9843 14.9406 21.8835 15.0633 21.76 15.16L21.34 15.48L21.8 15.74C21.9847 15.8301 22.1372 15.9749 22.2367 16.1548C22.3362 16.3346 22.3779 16.5408 22.356 16.7452C22.3341 16.9495 22.2498 17.1422 22.1146 17.297C21.9793 17.4517 21.7996 17.561 21.6 17.61L21.57 17.56Z" />
				<path d="M25.48 27.93H4.48C3.82043 27.9247 3.18967 27.659 2.72515 27.1907C2.26062 26.7225 1.99998 26.0896 2 25.43V4.42999C2 3.76695 2.26339 3.13107 2.73223 2.66223C3.20107 2.19338 3.83696 1.92999 4.5 1.92999H25.5C26.163 1.92999 26.7989 2.19338 27.2678 2.66223C27.7366 3.13107 28 3.76695 28 4.42999V25.43C28 25.76 27.9347 26.0867 27.8078 26.3913C27.6809 26.696 27.495 26.9725 27.2607 27.2049C27.0264 27.4373 26.7485 27.621 26.4429 27.7455C26.1372 27.8699 25.81 27.9326 25.48 27.93ZM4.48 3.92999C4.34819 3.93255 4.2225 3.98605 4.12928 4.07927C4.03606 4.17249 3.98256 4.29819 3.98 4.42999V25.43C3.98 25.5626 4.03268 25.6898 4.12645 25.7835C4.22021 25.8773 4.34739 25.93 4.48 25.93H25.48C25.6126 25.93 25.7398 25.8773 25.8336 25.7835C25.9273 25.6898 25.98 25.5626 25.98 25.43V4.42999C25.98 4.29738 25.9273 4.17021 25.8336 4.07644C25.7398 3.98267 25.6126 3.92999 25.48 3.92999H4.48Z" />
				</svg>',
		),

		array(
			'name'   => __( 'Facebook Comments', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'facebookcomments',
			'id'     => 36,
			'icon'   => '<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M3.13 28C2.94034 27.9985 2.75305 27.9576 2.58 27.88C2.31249 27.7733 2.08344 27.5882 1.92286 27.3491C1.76227 27.11 1.67762 26.828 1.68 26.54V5.34999C1.68 4.37665 2.06666 3.44317 2.75492 2.75491C3.44318 2.06665 4.37666 1.67999 5.35 1.67999H24.65C25.6225 1.68263 26.5545 2.07014 27.2422 2.75783C27.9299 3.44551 28.3174 4.37746 28.32 5.34999V19.83C28.3174 20.8016 27.9295 21.7325 27.2416 22.4186C26.5536 23.1047 25.6216 23.49 24.65 23.49H8.28L4.16 27.61C3.88133 27.8704 3.51127 28.0105 3.13 28ZM5.35 4.17999C5.19683 4.17999 5.04516 4.21032 4.90377 4.26924C4.76238 4.32816 4.63405 4.4145 4.5262 4.52328C4.41836 4.63205 4.33312 4.76111 4.27542 4.90301C4.21771 5.0449 4.18868 5.19682 4.19 5.34999V24.05L7.24 21H24.65C24.8032 21.0013 24.9551 20.9723 25.097 20.9146C25.2389 20.8569 25.3679 20.7716 25.4767 20.6638C25.5855 20.5559 25.6718 20.4276 25.7308 20.2862C25.7897 20.1448 25.82 19.9932 25.82 19.84V5.34999C25.82 5.03969 25.6967 4.7421 25.4773 4.52268C25.2579 4.30326 24.9603 4.17999 24.65 4.17999H5.35ZM11.59 13.31L11.9 11.31H10V10C9.9827 9.84694 10.001 9.69194 10.0535 9.54712C10.1059 9.40229 10.1911 9.27154 10.3025 9.16506C10.4138 9.05859 10.5482 8.97927 10.6952 8.93329C10.8422 8.88731 10.9979 8.87592 11.15 8.9H12V7.15C11.4746 7.05974 10.943 7.0096 10.41 7C10.0473 6.97295 9.683 7.02603 9.34306 7.15548C9.00313 7.28492 8.69582 7.48756 8.44294 7.74903C8.19006 8.0105 7.99779 8.3244 7.87977 8.66847C7.76175 9.01254 7.72086 9.37836 7.76 9.74V11.28H6V13.28H7.76V18.18C8.12352 18.2406 8.49147 18.2707 8.86 18.27C9.24102 18.2835 9.62249 18.2634 10 18.21V13.31H11.59ZM13.98 8.92999H23.98V9.92999H13.98V8.92999ZM22.98 14.93H13.98V15.93H22.98V14.93ZM13.98 11.93H20.98V12.93H13.98V11.93Z" />
				</svg>
				',
		),

		array(
			'name'   => __( 'Facebook Page', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'facebookpage',
			'id'     => 37,
			'icon'   => '
				<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
				<path fill-rule="evenodd" clip-rule="evenodd" d="M29 13.32C29 13.8723 28.5523 14.32 28 14.32H13.4V16.94C13.4 17.4923 12.9523 17.94 12.4 17.94H5.3C4.74772 17.94 4.3 17.4923 4.3 16.94V14.32H2C1.44771 14.32 1 13.8723 1 13.32V2C1 1.44771 1.44772 1 2 1H28C28.5523 1 29 1.44772 29 2V13.32ZM27 12.32H13.4V8.61999C13.4 8.06771 12.9523 7.62 12.4 7.62H5.3C4.74772 7.62 4.3 8.06771 4.3 8.62V12.32H3V4C3 3.44772 3.44772 3 4 3H26C26.5523 3 27 3.44771 27 4V12.32ZM14 9.48001L17.46 4.76001C17.4973 4.71033 17.5456 4.67001 17.6011 4.64224C17.6567 4.61446 17.7179 4.60001 17.78 4.60001C17.8421 4.60001 17.9033 4.61446 17.9589 4.64224C18.0144 4.67001 18.0627 4.71033 18.1 4.76001L20.84 8.46001C20.8532 8.48285 20.8721 8.50183 20.8949 8.51503C20.9177 8.52822 20.9436 8.53517 20.97 8.53517C20.9964 8.53517 21.0223 8.52822 21.0451 8.51503C21.0679 8.50183 21.0868 8.48285 21.1 8.46001L22.83 6.00001C22.8656 5.94637 22.9139 5.90238 22.9706 5.87195C23.0273 5.84151 23.0906 5.82559 23.155 5.82559C23.2194 5.82559 23.2827 5.84151 23.3394 5.87195C23.3961 5.90238 23.4444 5.94637 23.48 6.00001L25.92 9.49001C25.9628 9.55127 25.9886 9.62286 25.9945 9.69739C26.0004 9.77191 25.9864 9.84667 25.9537 9.91394C25.9211 9.98121 25.8711 10.0386 25.809 10.0801C25.7468 10.1216 25.6746 10.1457 25.6 10.15H14.32C14.2437 10.1469 14.1697 10.123 14.106 10.081C14.0422 10.0389 13.9911 9.98028 13.9582 9.91137C13.9253 9.84247 13.9118 9.76589 13.9192 9.68989C13.9265 9.61388 13.9545 9.54132 14 9.48001ZM17 24.29L19.43 21.05C19.4553 21.0187 19.4873 20.9934 19.5236 20.9761C19.56 20.9587 19.5997 20.9497 19.64 20.9497C19.6803 20.9497 19.72 20.9587 19.7564 20.9761C19.7927 20.9934 19.8247 21.0187 19.85 21.05L21.74 23.59C21.749 23.6045 21.7615 23.6164 21.7764 23.6247C21.7912 23.633 21.808 23.6373 21.825 23.6373C21.842 23.6373 21.8588 23.633 21.8736 23.6247C21.8885 23.6164 21.901 23.6045 21.91 23.59L23.1 21.87C23.1246 21.8329 23.1581 21.8024 23.1973 21.7813C23.2366 21.7603 23.2804 21.7493 23.325 21.7493C23.3696 21.7493 23.4134 21.7603 23.4527 21.7813C23.4919 21.8024 23.5254 21.8329 23.55 21.87L25.23 24.3C25.2584 24.3429 25.2749 24.3925 25.2778 24.4439C25.2807 24.4952 25.2699 24.5464 25.2465 24.5922C25.2231 24.638 25.1879 24.6768 25.1446 24.7045C25.1013 24.7322 25.0514 24.7479 25 24.75H17.22C17.1678 24.7474 17.1174 24.7307 17.0739 24.7017C17.0304 24.6728 16.9956 24.6326 16.9731 24.5855C16.9505 24.5384 16.9411 24.4861 16.9459 24.434C16.9506 24.382 16.9693 24.3323 17 24.29ZM12.4 8.62V16.94H5.3V8.62H12.4ZM15 15.93H28V16.92H15V15.93ZM27 18.94V27H16V18.94H27ZM28 18.94C28 18.3877 27.5523 17.94 27 17.94H16C15.4477 17.94 15 18.3877 15 18.94V27C15 27.5523 15.4477 28 16 28H27C27.5523 28 28 27.5523 28 27V18.94ZM4.3 18.93H13.4V19.93H4.3V18.93ZM13.4 20.93H4.3V21.93H13.4V20.93ZM4.3 22.93H13.4V23.93H4.3V22.93ZM13.4 24.93H4.3V25.93H13.4V24.93ZM4.3 26.93H13.4V27.93H4.3V26.93ZM10.13 12.3L10 13.16H9.26V15.25C9.10684 15.2603 8.95316 15.2603 8.8 15.25C8.6435 15.2603 8.4865 15.2603 8.33 15.25V13.16H7.57V12.3H8.33V11.64C8.31327 11.4862 8.33074 11.3306 8.38117 11.1843C8.4316 11.038 8.51374 10.9046 8.62172 10.7938C8.72969 10.683 8.86083 10.5974 9.00575 10.5431C9.15067 10.4889 9.30578 10.4673 9.46 10.48C9.68453 10.483 9.9085 10.5031 10.13 10.54V11.27H9.75C9.68555 11.2625 9.62023 11.2692 9.55871 11.2899C9.4972 11.3106 9.44101 11.3446 9.39418 11.3895C9.34735 11.4344 9.31104 11.4891 9.28784 11.5497C9.26464 11.6103 9.25513 11.6753 9.26 11.74V12.3H10.13Z"/>
				</svg>',
		),

		array(
			'name'   => __( 'Facebook Embed', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'facebookembed',
			'id'     => 38,
			'icon'   => '
		<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
		<path fill-rule="evenodd" clip-rule="evenodd" d="M23.6023 7.34992H3.17535V21.4816H11.9735C12.13 21.4816 12.2801 21.5438 12.3908 21.6545C12.5015 21.7651 12.5637 21.9153 12.5637 22.0718V23.2522C12.5637 23.4087 12.5015 23.5588 12.3908 23.6695C12.2801 23.7802 12.13 23.8423 11.9735 23.8423H3.15349C2.52738 23.8423 1.92692 23.5936 1.48419 23.1509C1.04147 22.7082 0.792746 22.1077 0.792746 21.4816V7.34992C0.794172 7.03897 0.857013 6.73137 0.977659 6.44478C1.09831 6.1582 1.27438 5.89827 1.49577 5.67992C1.71716 5.46158 1.97951 5.28912 2.26774 5.17246C2.55597 5.05579 2.86441 4.99722 3.17535 5.0001H23.5805C24.2028 5.00298 24.7988 5.25147 25.2389 5.69152C25.6789 6.13158 25.9274 6.72759 25.9303 7.34992V15.0005C25.9304 15.1533 25.8712 15.3002 25.7652 15.4103C25.6592 15.5203 25.5147 15.585 25.362 15.5907H24.1925C24.036 15.5907 23.8859 15.5285 23.7752 15.4178C23.6645 15.3071 23.6023 15.157 23.6023 15.0005V7.34992ZM29.1873 21.6127V20.6947L28.3238 20.2138L26.2473 19.0771L24.4221 18.0498V19.6127L24.8046 19.7985L27.3402 21.0881L24.6188 22.3232L24.4221 22.4215V23.9626L29.1873 21.6127ZM16.6185 13.9731L11.0882 10.279C11.0056 10.2231 10.9092 10.1909 10.8096 10.1859C10.71 10.1809 10.6109 10.2033 10.5231 10.2506C10.4353 10.2979 10.362 10.3683 10.3114 10.4542C10.2607 10.5401 10.2346 10.6383 10.2357 10.738V18.1044C10.2346 18.2042 10.2607 18.3023 10.3114 18.3882C10.362 18.4742 10.4353 18.5446 10.5231 18.5919C10.6109 18.6392 10.71 18.6615 10.8096 18.6565C10.9092 18.6515 11.0056 18.6193 11.0882 18.5635L16.6185 14.8803C16.6929 14.8303 16.7538 14.7628 16.796 14.6837C16.8381 14.6046 16.8601 14.5163 16.8601 14.4267C16.8601 14.3371 16.8381 14.2488 16.796 14.1697C16.7538 14.0906 16.6929 14.0231 16.6185 13.9731ZM24.0614 17.1098L23.1761 19.7985L22.3564 22.3231L21.482 24.9899H19.8536L20.717 22.3231L21.5476 19.7985L22.422 17.1098H24.0614ZM19.0557 19.7985L16.5201 21.0881L19.2415 22.3232L19.4383 22.4215V23.9626L16.1157 22.3232L14.6621 21.6127V20.6947L16.2906 19.7985L19.4383 18.0498V19.6127L19.0557 19.7985Z" />
		</svg>
		',
		),

		array(
			'name'   => __( 'Twitter Embed Tweet', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'twitterembedtweet',
			'id'     => 40,
			'icon'   => '
			<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M26.3077 29H3.69231C2.97826 29 2.29346 28.7163 1.78856 28.2114C1.28365 27.7065 1 27.0217 1 26.3077V3.69231C1 2.97826 1.28365 2.29346 1.78856 1.78856C2.29346 1.28365 2.97826 1 3.69231 1H26.3077C27.0217 1 27.7065 1.28365 28.2114 1.78856C28.7163 2.29346 29 2.97826 29 3.69231V26.3077C29 27.0217 28.7163 27.7065 28.2114 28.2114C27.7065 28.7163 27.0217 29 26.3077 29ZM3.69231 3.15385C3.5495 3.15385 3.41254 3.21058 3.31156 3.31156C3.21058 3.41254 3.15385 3.5495 3.15385 3.69231V17.1538H26.8462V3.69231C26.8462 3.5495 26.7894 3.41254 26.6884 3.31156C26.5875 3.21058 26.4505 3.15385 26.3077 3.15385H3.69231ZM26.8462 18.2308H3.15385V26.3077C3.15385 26.4505 3.21058 26.5875 3.31156 26.6884C3.41254 26.7894 3.5495 26.8462 3.69231 26.8462H26.3077C26.4505 26.8462 26.5875 26.7894 26.6884 26.6884C26.7894 26.5875 26.8462 26.4505 26.8462 26.3077V18.2308ZM19.7889 7.66295V7.98856C19.7989 8.90387 19.6276 9.81212 19.2849 10.6609C18.9423 11.5097 18.4349 12.2823 17.7922 12.9341C17.1495 13.5859 16.3841 14.104 15.5402 14.4585C14.6963 14.8131 13.7906 14.9971 12.8752 14.9999C11.5484 15.0073 10.2479 14.6303 9.13076 13.9145H9.71684C10.821 13.912 11.8906 13.5287 12.745 12.8292C12.2333 12.8183 11.7379 12.6468 11.329 12.3391C10.92 12.0314 10.618 11.603 10.4657 11.1144C10.8227 11.1977 11.1941 11.1977 11.5511 11.1144C11.0017 10.995 10.51 10.6905 10.1583 10.2518C9.80663 9.81321 9.61629 9.26709 9.61916 8.70489C9.95245 8.88906 10.324 8.9931 10.7045 9.00878C10.1956 8.65776 9.83578 8.12967 9.6953 7.52761C9.55482 6.92555 9.64377 6.29275 9.94477 5.75274C10.5576 6.51252 11.3239 7.13437 12.1936 7.57763C13.0633 8.02089 14.0167 8.27557 14.9916 8.32501C14.8927 7.90504 14.9058 7.46645 15.0296 7.05313C15.1534 6.6398 15.3836 6.26624 15.6971 5.96981C15.9304 5.74738 16.2056 5.57355 16.5067 5.45846C16.8078 5.34336 17.1288 5.28929 17.4509 5.29939C17.7731 5.30949 18.0901 5.38356 18.3834 5.51729C18.6767 5.65102 18.9405 5.84174 19.1594 6.07835C19.7058 5.96541 20.2301 5.76376 20.7114 5.48141C20.5255 6.04995 20.1399 6.5319 19.6261 6.83809C20.1051 6.75925 20.5697 6.60926 21.0044 6.3931C20.6774 6.8848 20.2658 7.31472 19.7889 7.66295ZM16.5723 19.5123L15.9262 21.5046L15.3123 23.3677L14.6769 25.3385H13.4708L14.1062 23.3677L14.72 21.5046L15.3662 19.5123H16.5723ZM12.8785 21.5046L11.0046 22.4631L13.0077 23.3677L13.1585 23.4323V24.5738L10.7139 23.3677L9.63694 22.84V22.1723L10.8323 21.5046L13.1585 20.2123V21.3646L12.8785 21.5046ZM20.3631 22.84V22.1723L19.7277 21.8061L18.1877 20.9662L16.8415 20.2123V21.3646L17.1215 21.5046L19.0061 22.4631L16.9923 23.3677L16.8415 23.4323V24.5738L20.3631 22.84Z"/>
			</svg>',
		),

		array(
			'name'   => __( 'Twitter Embed Timeline', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'twitterembedtimeline',
			'id'     => 80,
			'icon'   => '
			<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M3.5 1H26.5C27.1927 1.03141 27.8447 1.33603 28.3132 1.84714C28.7818 2.35825 29.0288 3.03421 29 3.727V25.273C29.0288 25.9658 28.7818 26.6418 28.3132 27.1529C27.8447 27.664 27.1927 27.9686 26.5 28H22.5C22.3615 27.9938 22.2311 27.9329 22.1374 27.8308C22.0437 27.7286 21.9943 27.5935 22 27.455V26.364C21.994 26.2253 22.0433 26.09 22.1371 25.9876C22.2308 25.8852 22.3613 25.8242 22.5 25.818H26.5C26.6385 25.8118 26.7689 25.7509 26.8626 25.6488C26.9563 25.5466 27.0057 25.4115 27 25.273V3.727C27.0057 3.5885 26.9563 3.45338 26.8626 3.35123C26.7689 3.24908 26.6385 3.18823 26.5 3.182H3.5C3.36152 3.18823 3.23115 3.24908 3.13743 3.35123C3.04372 3.45338 2.9943 3.5885 3 3.727V25.273C2.9943 25.4115 3.04372 25.5466 3.13743 25.6488C3.23115 25.7509 3.36152 25.8118 3.5 25.818H7.5C7.63866 25.8242 7.76919 25.8852 7.86293 25.9876C7.95667 26.09 8.00597 26.2253 8 26.364V27.455C8.00569 27.5935 7.95628 27.7286 7.86256 27.8308C7.76885 27.9329 7.63848 27.9938 7.5 28H3.5C2.80732 27.9686 2.15532 27.664 1.68675 27.1529C1.21819 26.6418 0.971244 25.9658 0.999999 25.273V3.727C0.971244 3.03421 1.21819 2.35825 1.68675 1.84714C2.15532 1.33603 2.80732 1.03141 3.5 1ZM15 7H25V8H15V7ZM15 9H22.423V10H15V9ZM25 11H15V12H25V11ZM15 15.07H25V16.07H15V15.07ZM22.423 17.07H15V18.07H22.423V17.07ZM15 19.07H25V20.07H15V19.07ZM13.015 25.046L11.256 26.031L13.138 26.969L13.279 27.038V28.215L10.979 26.969L9.974 26.423V25.731L11.095 25.046L13.279 23.715V24.9L13.015 25.046ZM15.87 25.046L16.476 23H15.342L14.736 25.046L14.162 26.969L13.563 29H14.697L15.296 26.969L15.87 25.046ZM20.026 25.731V26.423L16.727 28.215V27.038L16.869 26.969L18.75 26.031L16.991 25.046L16.727 24.9V23.715L17.99 24.492L19.427 25.362L20.026 25.731ZM9.69259 12.385C9.19503 12.5893 8.66184 12.6926 8.12401 12.689L8.11901 12.691C7.33901 12.6913 6.57536 12.4674 5.91901 12.046C6.03286 12.0592 6.14738 12.0659 6.26201 12.066C6.9088 12.0668 7.53709 11.8502 8.04601 11.451C7.74598 11.4451 7.45531 11.3455 7.21468 11.1662C6.97405 10.9868 6.7955 10.7368 6.70401 10.451C6.79306 10.4675 6.88343 10.4759 6.97401 10.476C7.10168 10.4763 7.22882 10.4595 7.35201 10.426C7.02703 10.3602 6.73479 10.1841 6.52483 9.9275C6.31487 9.67088 6.20011 9.34956 6.20001 9.01799V8.99999C6.40034 9.11176 6.6247 9.17351 6.85401 9.17999C6.55056 8.97642 6.33599 8.66497 6.2539 8.3089C6.1718 7.95284 6.22833 7.57888 6.41201 7.26299C6.77284 7.7066 7.22292 8.06938 7.73303 8.3278C8.24314 8.58621 8.80189 8.73448 9.37301 8.76299C9.34759 8.65586 9.33483 8.5461 9.33501 8.43599C9.33525 8.14798 9.42203 7.86668 9.58409 7.62859C9.74616 7.3905 9.97603 7.2066 10.2439 7.10075C10.5117 6.9949 10.8052 6.97198 11.0863 7.03497C11.3673 7.09796 11.6229 7.24394 11.82 7.45399C12.1416 7.39029 12.45 7.27227 12.732 7.10499C12.6248 7.43791 12.4002 7.72047 12.1 7.89999C12.3852 7.8653 12.6636 7.78812 12.926 7.67099C12.733 7.95893 12.4906 8.21047 12.21 8.41399V8.59999C12.214 9.13783 12.1111 9.67109 11.9072 10.1688C11.7033 10.6665 11.4025 11.1187 11.0223 11.4992C10.6421 11.8796 10.1901 12.1807 9.69259 12.385ZM8.124 21C8.66158 21.0036 9.19452 20.9004 9.69188 20.6963C10.1892 20.4922 10.6411 20.1914 11.0212 19.8112C11.4014 19.4311 11.7022 18.9792 11.9063 18.4819C12.1104 17.9845 12.2136 17.4516 12.21 16.914V16.728C12.4906 16.5245 12.733 16.2729 12.926 15.985C12.6638 16.101 12.3857 16.1772 12.101 16.211C12.4012 16.0315 12.6258 15.7489 12.733 15.416C12.451 15.5833 12.1426 15.7013 11.821 15.765C11.6049 15.5336 11.3184 15.3802 11.006 15.3285C10.6937 15.2768 10.373 15.3298 10.0939 15.4793C9.81477 15.6287 9.59286 15.8662 9.46267 16.1548C9.33248 16.4433 9.3013 16.7669 9.374 17.075C8.80289 17.0464 8.24417 16.8981 7.73407 16.6397C7.22397 16.3813 6.77388 16.0186 6.413 15.575C6.22961 15.8912 6.17355 16.2655 6.25621 16.6215C6.33887 16.9776 6.55406 17.2889 6.858 17.492C6.63014 17.4852 6.40723 17.4238 6.208 17.313V17.331C6.20811 17.6626 6.32287 17.9839 6.53282 18.2405C6.74278 18.4971 7.03502 18.6732 7.36 18.739C7.23681 18.7725 7.10967 18.7893 6.982 18.789C6.89143 18.7889 6.80105 18.7805 6.712 18.764C6.80349 19.0498 6.98205 19.2999 7.22267 19.4792C7.4633 19.6585 7.75397 19.7581 8.054 19.764C7.54509 20.1632 6.91679 20.3798 6.27 20.379C6.15538 20.3789 6.04086 20.3722 5.927 20.359C6.58336 20.7804 7.34701 21.0043 8.127 21.004L8.124 21Z"/>
			</svg>',
		),

		array(
			'name'   => __( 'Twitter Tweet Button', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'twittertweetbutton',
			'id'     => 82,
			'icon'   => '
			<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M26.6935 3.0749C26.6322 3.04921 26.5664 3.03599 26.5 3.036H3.50001C3.43359 3.03599 3.36782 3.04921 3.30657 3.0749C3.24531 3.10059 3.18979 3.13823 3.14324 3.18561C3.09669 3.233 3.06005 3.28919 3.03546 3.35089C3.01087 3.4126 2.99882 3.47859 3.00001 3.545V26.455C2.99882 26.5214 3.01087 26.5874 3.03546 26.6491C3.06005 26.7108 3.09669 26.767 3.14324 26.8144C3.18979 26.8618 3.24531 26.8994 3.30657 26.9251C3.36782 26.9508 3.43359 26.964 3.50001 26.964H26.5C26.5664 26.964 26.6322 26.9508 26.6935 26.9251C26.7547 26.8994 26.8102 26.8618 26.8568 26.8144C26.9033 26.767 26.94 26.7108 26.9646 26.6491C26.9892 26.5874 27.0012 26.5214 27 26.455V3.545C27.0012 3.47859 26.9892 3.4126 26.9646 3.35089C26.94 3.28919 26.9033 3.233 26.8568 3.18561C26.8102 3.13823 26.7547 3.10059 26.6935 3.0749ZM3.50001 1H26.5C27.1687 1.00686 27.8074 1.27863 28.2761 1.75572C28.7447 2.2328 29.0051 2.87626 29 3.545V26.455C29.0051 27.1237 28.7447 27.7672 28.2761 28.2443C27.8074 28.7214 27.1687 28.9931 26.5 29H3.50001C2.83129 28.9931 2.19257 28.7214 1.72393 28.2443C1.25528 27.7672 0.994946 27.1237 1.00001 26.455V3.545C0.994946 2.87626 1.25528 2.2328 1.72393 1.75572C2.19257 1.27863 2.83129 1.00686 3.50001 1ZM25 22H5V23H25V22ZM25 24H5V25H25V24ZM8.134 5.17701L5.073 10.277C4.896 10.577 5.062 10.999 5.355 10.999H15.279C15.567 10.999 15.734 10.586 15.567 10.288L13.423 6.47801C13.3986 6.42189 13.3584 6.37411 13.3072 6.34055C13.256 6.307 13.1962 6.28912 13.135 6.28912C13.0738 6.28912 13.014 6.307 12.9628 6.34055C12.9116 6.37411 12.8714 6.42189 12.847 6.47801L11.33 9.17801C11.3201 9.19998 11.3041 9.21862 11.2839 9.2317C11.2637 9.24478 11.2401 9.25174 11.216 9.25174C11.1919 9.25174 11.1683 9.24478 11.1481 9.2317C11.1279 9.21862 11.1119 9.19998 11.102 9.17801L8.7 5.17701C8.67496 5.12305 8.63501 5.07738 8.58487 5.04538C8.53473 5.01337 8.47649 4.99637 8.417 4.99637C8.35752 4.99637 8.29927 5.01337 8.24913 5.04538C8.19899 5.07738 8.15905 5.12305 8.134 5.17701ZM17.381 10.143H24.105V11H17.381V10.143ZM23.476 6.71399H17.381V7.57099H23.476V6.71399ZM17.381 8.42899H25V9.28599H17.381V8.42899ZM24.5 13H5.5C5.22386 13 5 13.2239 5 13.5V20.5C5 20.7761 5.22386 21 5.5 21H24.5C24.7761 21 25 20.7761 25 20.5V13.5C25 13.2239 24.7761 13 24.5 13ZM8.08699 19.4C8.47255 19.3944 8.85319 19.3125 9.20688 19.1589C9.56058 19.0053 9.8803 18.7831 10.1476 18.5051C10.4148 18.2271 10.6243 17.8989 10.764 17.5395C10.9036 17.1801 10.9705 16.7965 10.961 16.411V16.275C11.1586 16.1248 11.3279 15.9406 11.461 15.731C11.2774 15.8157 11.0817 15.8713 10.881 15.896C11.0942 15.762 11.2521 15.5558 11.326 15.315C11.1285 15.4367 10.9112 15.523 10.684 15.57C10.5913 15.466 10.4778 15.3827 10.3508 15.3255C10.2239 15.2683 10.0863 15.2385 9.94699 15.238C9.67362 15.2435 9.41361 15.3573 9.22406 15.5544C9.0345 15.7514 8.9309 16.0156 8.93599 16.289C8.93596 16.3694 8.94468 16.4495 8.96199 16.528C8.5564 16.5045 8.16059 16.3942 7.80138 16.2044C7.44217 16.0146 7.12794 15.7498 6.87999 15.428C6.78968 15.5893 6.7425 15.7712 6.74299 15.956C6.74201 16.1272 6.78242 16.296 6.86077 16.4482C6.93912 16.6004 7.0531 16.7314 7.19299 16.83C7.03188 16.8246 6.87459 16.7796 6.73499 16.699V16.712C6.73162 16.9506 6.81035 17.1832 6.95799 17.3707C7.10563 17.5582 7.31322 17.6893 7.54599 17.742C7.45912 17.7666 7.36927 17.7791 7.27899 17.779C7.21519 17.7787 7.15157 17.7724 7.08899 17.76C7.14949 17.9655 7.27331 18.1468 7.44281 18.2778C7.6123 18.4089 7.81883 18.4832 8.03299 18.49C7.67938 18.7808 7.23581 18.9398 6.77799 18.94C6.69742 18.94 6.61693 18.935 6.53699 18.925C6.99512 19.2324 7.53428 19.3967 8.08599 19.397L8.08699 19.4ZM13.891 18.5H13.257V16.551H12.685V16H14.461V16.551H13.891V18.5ZM16.118 17.578L16.323 18.5L16.986 18.494L17.486 16.56H16.886L16.726 17.302C16.7034 17.405 16.6867 17.5091 16.676 17.614L16.673 17.6418L16.673 17.6419C16.6603 17.7586 16.6496 17.8573 16.644 17.937H16.634C16.6131 17.7399 16.5821 17.5439 16.541 17.35L16.387 16.56H15.695L15.527 17.34C15.4843 17.5378 15.4545 17.7383 15.438 17.94H15.429C15.415 17.7268 15.3876 17.5147 15.347 17.305L15.2 16.563H14.579L15.079 18.497H15.738L15.922 17.676C15.94 17.5953 15.9753 17.3953 16.028 17.076H16.037L16.069 17.3L16.118 17.578ZM18.625 18.53C18.4969 18.5373 18.3688 18.5182 18.2484 18.474C18.128 18.4298 18.0179 18.3614 17.925 18.273C17.8368 18.1739 17.7691 18.0582 17.726 17.9327C17.6829 17.8072 17.6652 17.6744 17.674 17.542C17.6555 17.2711 17.7385 17.003 17.907 16.79C18.0823 16.627 18.3111 16.5336 18.5504 16.5271C18.7897 16.5207 19.0231 16.6017 19.207 16.755C19.2863 16.844 19.3471 16.948 19.3855 17.0608C19.424 17.1737 19.4395 17.2931 19.431 17.412V17.712H18.3C18.2995 17.7597 18.309 17.8069 18.328 17.8507C18.3469 17.8944 18.3749 17.9337 18.41 17.966C18.491 18.031 18.5933 18.0638 18.697 18.058C18.7979 18.0588 18.8986 18.0477 18.997 18.025C19.1008 17.9985 19.2015 17.9606 19.297 17.912V18.391C19.2033 18.4433 19.1021 18.4807 18.997 18.502C18.8742 18.5233 18.7496 18.5327 18.625 18.53ZM18.588 16.982C18.5539 16.9808 18.5198 16.9867 18.4881 16.9994C18.4564 17.0122 18.4278 17.0315 18.404 17.056C18.3467 17.1201 18.315 17.203 18.315 17.289H18.854C18.8566 17.2078 18.83 17.1283 18.779 17.065C18.7555 17.0376 18.7261 17.016 18.693 17.0016C18.6599 16.9872 18.624 16.9805 18.588 16.982ZM20.2752 18.475C20.3967 18.5192 20.526 18.538 20.655 18.53C20.7806 18.5328 20.9062 18.5235 21.03 18.502C21.1351 18.4808 21.2364 18.4434 21.33 18.391V17.912C21.2345 17.9608 21.1339 17.9987 21.03 18.025C20.9316 18.0477 20.8309 18.0588 20.73 18.058C20.6262 18.064 20.5239 18.0312 20.443 17.966C20.4079 17.9337 20.3799 17.8944 20.3608 17.8507C20.3417 17.807 20.3319 17.7597 20.332 17.712H21.457V17.412C21.4653 17.293 21.4497 17.1736 21.4111 17.0607C21.3724 16.9479 21.3115 16.8439 21.232 16.755C21.0483 16.6013 20.8148 16.52 20.5754 16.5265C20.3359 16.5329 20.1071 16.6266 19.932 16.79C19.7635 17.003 19.6805 17.2711 19.699 17.542C19.6901 17.6743 19.7076 17.8071 19.7505 17.9326C19.7935 18.0581 19.8609 18.1738 19.949 18.273C20.0427 18.362 20.1538 18.4308 20.2752 18.475ZM20.5177 16.9994C20.5495 16.9867 20.5837 16.9808 20.618 16.982C20.6539 16.9805 20.6897 16.9871 20.7226 17.0015C20.7555 17.0159 20.7847 17.0376 20.808 17.065C20.8593 17.1282 20.8863 17.2077 20.884 17.289H20.345C20.3448 17.2032 20.3761 17.1203 20.433 17.056C20.457 17.0315 20.4858 17.0122 20.5177 16.9994ZM22.7 18C22.8031 17.9953 22.9046 17.9726 23 17.933V18.42C22.9225 18.4559 22.8414 18.4834 22.758 18.502C22.6698 18.5201 22.58 18.5285 22.49 18.527C22.4067 18.5349 22.3226 18.5241 22.244 18.4956C22.1653 18.4671 22.0939 18.4214 22.035 18.362C21.9305 18.215 21.8809 18.0359 21.895 17.856V17.056H21.676V16.79L21.955 16.58L22.117 16.174H22.527V16.562H22.973V17.062H22.527V17.815C22.527 17.94 22.583 18 22.7 18Z"/>
			</svg>',
		),

		array(
			'name'   => __( 'Twitter Follow Button', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'twitterfollowbutton',
			'id'     => 84,
			'icon'   => '
			<svg  class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M26.6935 3.0749C26.6322 3.04921 26.5664 3.03599 26.5 3.036H3.50001C3.43359 3.03599 3.36782 3.04921 3.30657 3.0749C3.24531 3.10059 3.18979 3.13823 3.14324 3.18561C3.09669 3.233 3.06005 3.28919 3.03546 3.35089C3.01087 3.4126 2.99882 3.47859 3.00001 3.545V26.455C2.99882 26.5214 3.01087 26.5874 3.03546 26.6491C3.06005 26.7108 3.09669 26.767 3.14324 26.8144C3.18979 26.8618 3.24531 26.8994 3.30657 26.9251C3.36782 26.9508 3.43359 26.964 3.50001 26.964H26.5C26.5664 26.964 26.6322 26.9508 26.6935 26.9251C26.7547 26.8994 26.8102 26.8618 26.8568 26.8144C26.9033 26.767 26.94 26.7108 26.9646 26.6491C26.9892 26.5874 27.0012 26.5214 27 26.455V3.545C27.0012 3.47859 26.9892 3.4126 26.9646 3.35089C26.94 3.28919 26.9033 3.233 26.8568 3.18561C26.8102 3.13823 26.7547 3.10059 26.6935 3.0749ZM3.50001 1H26.5C27.1687 1.00686 27.8074 1.27863 28.2761 1.75572C28.7447 2.2328 29.0051 2.87626 29 3.545V26.455C29.0051 27.1237 28.7447 27.7672 28.2761 28.2443C27.8074 28.7214 27.1687 28.9931 26.5 29H3.50001C2.83129 28.9931 2.19257 28.7214 1.72393 28.2443C1.25528 27.7672 0.994946 27.1237 1.00001 26.455V3.545C0.994946 2.87626 1.25528 2.2328 1.72393 1.75572C2.19257 1.27863 2.83129 1.00686 3.50001 1ZM25 22H5V23H25V22ZM25 24H5V25H25V24ZM8.134 14.177L5.073 19.277C4.896 19.577 5.062 19.999 5.355 19.999H15.279C15.567 19.999 15.734 19.586 15.567 19.288L13.423 15.478C13.3986 15.4219 13.3584 15.3741 13.3072 15.3406C13.256 15.307 13.1962 15.2891 13.135 15.2891C13.0738 15.2891 13.014 15.307 12.9628 15.3406C12.9116 15.3741 12.8714 15.4219 12.847 15.478L11.33 18.178C11.3201 18.2 11.3041 18.2186 11.2839 18.2317C11.2637 18.2448 11.2401 18.2517 11.216 18.2517C11.1919 18.2517 11.1683 18.2448 11.1481 18.2317C11.1279 18.2186 11.1119 18.2 11.102 18.178L8.7 14.177C8.67496 14.1231 8.63501 14.0774 8.58487 14.0454C8.53473 14.0134 8.47649 13.9964 8.417 13.9964C8.35752 13.9964 8.29927 14.0134 8.24913 14.0454C8.19899 14.0774 8.15905 14.1231 8.134 14.177ZM17.381 19.143H24.105V20H17.381V19.143ZM23.476 15.714H17.381V16.571H23.476V15.714ZM17.381 17.429H25V18.286H17.381V17.429ZM24.5 5H5.5C5.22386 5 5 5.22386 5 5.5V12.5C5 12.7761 5.22386 13 5.5 13H24.5C24.7761 13 25 12.7761 25 12.5V5.5C25 5.22386 24.7761 5 24.5 5ZM9.20689 11.1589C8.8532 11.3125 8.47256 11.3944 8.08699 11.4V11.398C7.53529 11.3977 6.99613 11.2334 6.53799 10.926C6.61794 10.936 6.69843 10.941 6.77899 10.941C7.23681 10.9408 7.68038 10.7818 8.03399 10.491C7.81984 10.4842 7.61331 10.4099 7.44381 10.2788C7.27432 10.1478 7.1505 9.96655 7.08999 9.76101C7.15258 9.77339 7.2162 9.77975 7.27999 9.78001C7.37028 9.78006 7.46013 9.7676 7.54699 9.74301C7.31423 9.6903 7.10664 9.55921 6.95899 9.3717C6.81135 9.18419 6.73262 8.95164 6.73599 8.71301V8.70001C6.87569 8.78025 7.03298 8.8249 7.19399 8.83001C7.05411 8.73137 6.94013 8.60039 6.86178 8.44821C6.78343 8.29603 6.74302 8.12717 6.74399 7.95601C6.7435 7.77115 6.79069 7.5893 6.88099 7.42801C7.12895 7.74983 7.44317 8.0146 7.80239 8.20439C8.1616 8.39418 8.55741 8.50454 8.96299 8.52801C8.94569 8.44952 8.93697 8.36938 8.93699 8.28901C8.9319 8.0158 9.03537 7.75172 9.22471 7.5547C9.41405 7.35768 9.6738 7.24378 9.94699 7.23801C10.0863 7.23851 10.2239 7.26833 10.3508 7.32553C10.4778 7.38274 10.5913 7.46603 10.684 7.57001C10.9112 7.52301 11.1285 7.43671 11.326 7.31501C11.2521 7.55577 11.0942 7.76197 10.881 7.89601C11.0817 7.87133 11.2774 7.81567 11.461 7.73101C11.3279 7.94058 11.1586 8.12479 10.961 8.27501V8.41101C10.9706 8.7965 10.9036 9.18005 10.764 9.5395C10.6243 9.89894 10.4148 10.2271 10.1476 10.5051C9.88031 10.7831 9.56058 11.0053 9.20689 11.1589ZM12.692 10.58H13.315V9.66501H14.015V9.13601H13.315V8.67101H14.077V8.14301H12.692V10.58ZM16.159 9.63101C16.1749 9.89373 16.0894 10.1525 15.92 10.354C15.8329 10.4426 15.7279 10.5115 15.612 10.5562C15.4961 10.6009 15.372 10.6202 15.248 10.613C15.1257 10.6187 15.0037 10.598 14.8901 10.5522C14.7766 10.5065 14.6742 10.4369 14.59 10.348C14.4198 10.1491 14.3325 9.89243 14.346 9.63101C14.33 9.36993 14.4161 9.11286 14.586 8.91401C14.6734 8.82611 14.7786 8.75783 14.8944 8.71369C15.0103 8.66955 15.1342 8.65057 15.258 8.65801C15.4234 8.65448 15.5867 8.69522 15.731 8.77601C15.8676 8.85548 15.9779 8.97337 16.048 9.11501C16.1249 9.27595 16.1629 9.45269 16.159 9.63101ZM14.982 9.63101C14.9754 9.75781 14.9969 9.88451 15.045 10.002C15.0629 10.0421 15.0926 10.0758 15.1301 10.0986C15.1676 10.1215 15.2112 10.1324 15.255 10.13C15.2987 10.1322 15.342 10.1209 15.379 10.0977C15.416 10.0744 15.445 10.0403 15.462 10C15.5065 9.8816 15.5266 9.75539 15.521 9.62901C15.5272 9.50436 15.5064 9.37985 15.46 9.26401C15.4395 9.2269 15.4095 9.19597 15.373 9.17442C15.3365 9.15288 15.2949 9.14152 15.2525 9.14152C15.2101 9.14152 15.1685 9.15288 15.132 9.17442C15.0955 9.19597 15.0655 9.2269 15.045 9.26401C14.9965 9.37999 14.9749 9.50548 14.982 9.63101ZM16.516 10.58H17.143V7.98599H16.516V10.58ZM18.2 10.58H17.573V7.98599H18.2V10.58ZM20.134 10.354C20.3034 10.1525 20.3889 9.89372 20.373 9.631C20.3769 9.45268 20.3388 9.27594 20.262 9.115C20.1918 8.97336 20.0816 8.85547 19.945 8.776C19.8007 8.69521 19.6374 8.65447 19.472 8.658C19.3482 8.65043 19.2242 8.66935 19.1084 8.7135C18.9925 8.75764 18.8874 8.826 18.8 8.914C18.6301 9.11285 18.544 9.36992 18.56 9.631C18.5465 9.89242 18.6338 10.1491 18.804 10.348C18.8882 10.4368 18.9905 10.5065 19.1041 10.5522C19.2176 10.598 19.3397 10.6187 19.462 10.613C19.586 10.6202 19.7101 10.6009 19.826 10.5562C19.9419 10.5115 20.0469 10.4426 20.134 10.354ZM19.259 10.002C19.2109 9.8845 19.1893 9.7578 19.196 9.631H19.2C19.1917 9.50577 19.2118 9.3803 19.259 9.264C19.2795 9.22689 19.3095 9.19596 19.346 9.17441C19.3825 9.15287 19.4241 9.14151 19.4665 9.14151C19.5089 9.14151 19.5505 9.15287 19.587 9.17441C19.6235 9.19596 19.6535 9.22689 19.674 9.264C19.7204 9.37984 19.7412 9.50435 19.735 9.629C19.7406 9.75538 19.7205 9.88159 19.676 10C19.659 10.0403 19.63 10.0744 19.593 10.0976C19.556 10.1209 19.5127 10.1322 19.469 10.13C19.4251 10.1326 19.3815 10.1217 19.344 10.0988C19.3065 10.0759 19.2768 10.0422 19.259 10.002ZM22.293 10.58L22.093 9.68L22.045 9.408L22.013 9.18999H22C21.947 9.5 21.912 9.69699 21.894 9.778L21.71 10.578H21.051L20.551 8.689H21.168L21.316 9.41399C21.3563 9.61871 21.3833 9.8258 21.397 10.034H21.407C21.4233 9.83791 21.4527 9.64314 21.495 9.451L21.663 8.689H22.356L22.51 9.461C22.5587 9.707 22.5897 9.898 22.603 10.034H22.612C22.619 9.95 22.63 9.844 22.644 9.719C22.6554 9.61819 22.6721 9.51805 22.694 9.41899L22.854 8.694H23.459L22.959 10.583L22.293 10.58Z"/>
			</svg>',
		),

		array(
			'name'   => __( 'Custom HTML', 'coming-soon' ),
			'is_pro' => false,
			'cat'    => 'adv',
			'type'   => 'custom-html',
			'id'     => 20,
			'icon'   => '
	<svg xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current " viewBox="0 0 24 24"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M9.4 16.6L4.8 12l4.6-4.6L8 6l-6 6 6 6 1.4-1.4zm5.2 0l4.6-4.6-4.6-4.6L16 6l6 6-6 6-1.4-1.4z"/></svg>',
		),
		array(
			'name'   => __( 'Add To Cart', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wcaddtocart',
			'id'     => 34,
			'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M15.48 11.69H17.09C17.22 11.69 17.3446 11.6384 17.4365 11.5465C17.5284 11.4546 17.58 11.3299 17.58 11.2V7.71999H21C21.0639 7.72 21.1271 7.70726 21.186 7.68252C21.2449 7.65777 21.2983 7.62152 21.343 7.57588C21.3877 7.53025 21.4228 7.47614 21.4464 7.41675C21.4699 7.35735 21.4813 7.29386 21.48 7.22999V5.55999C21.48 5.43175 21.4298 5.3086 21.34 5.21699C21.2503 5.12538 21.1282 5.07261 21 5.06999H17.58V1.58999C17.5774 1.45912 17.5236 1.3345 17.4301 1.24288C17.3366 1.15127 17.2109 1.09996 17.08 1.09999H15.47C15.4061 1.09866 15.3426 1.11009 15.2832 1.13362C15.2238 1.15714 15.1697 1.19229 15.1241 1.23699C15.0785 1.2817 15.0422 1.33506 15.0175 1.39396C14.9927 1.45286 14.98 1.5161 14.98 1.57999V5.06999H11.58C11.4518 5.06996 11.3286 5.12021 11.237 5.20995C11.1454 5.29969 11.0926 5.42177 11.09 5.54999V7.21999C11.0926 7.35179 11.1461 7.47749 11.2393 7.57071C11.3325 7.66393 11.4582 7.71743 11.59 7.71999H15V11.19C14.9999 11.3192 15.0498 11.4434 15.1393 11.5367C15.2288 11.6299 15.3509 11.6848 15.48 11.69ZM9.8 23.61C9.27349 23.5981 8.75536 23.7433 8.31175 24.0271C7.86814 24.311 7.51916 24.7206 7.30936 25.2036C7.09956 25.6867 7.03844 26.2213 7.13382 26.7392C7.22919 27.2572 7.47673 27.7349 7.84483 28.1116C8.21294 28.4882 8.68492 28.7466 9.20054 28.8538C9.71616 28.961 10.252 28.9122 10.7398 28.7135C11.2275 28.5148 11.645 28.1753 11.9389 27.7383C12.2328 27.3013 12.3899 26.7866 12.39 26.26C12.3953 25.9156 12.3323 25.5735 12.2048 25.2535C12.0773 24.9335 11.8876 24.642 11.6469 24.3956C11.4061 24.1493 11.1189 23.953 10.802 23.8182C10.485 23.6833 10.1445 23.6126 9.8 23.61ZM22.8 23.61C22.2735 23.5981 21.7554 23.7433 21.3118 24.0271C20.8681 24.311 20.5192 24.7206 20.3094 25.2036C20.0996 25.6867 20.0384 26.2213 20.1338 26.7392C20.2292 27.2572 20.4767 27.7349 20.8448 28.1116C21.2129 28.4882 21.6849 28.7466 22.2005 28.8538C22.7162 28.961 23.252 28.9122 23.7398 28.7135C24.2275 28.5148 24.645 28.1753 24.9389 27.7383C25.2328 27.3013 25.3899 26.7866 25.39 26.26C25.394 25.9126 25.3288 25.5678 25.1983 25.2458C25.0678 24.9238 24.8745 24.631 24.6298 24.3844C24.385 24.1378 24.0937 23.9423 23.7727 23.8094C23.4517 23.6764 23.1074 23.6086 22.76 23.61H22.8ZM10 19.3V19.14L11.22 17H20.88C21.3469 16.9984 21.8047 16.8702 22.2044 16.6289C22.6042 16.3876 22.931 16.0424 23.15 15.63L27.92 6.77999C27.9817 6.66553 27.9963 6.53155 27.9608 6.40647C27.9254 6.28139 27.8426 6.17505 27.73 6.10999L26.21 5.25999C26.1521 5.22778 26.0882 5.2079 26.0223 5.2016C25.9563 5.1953 25.8898 5.20272 25.8269 5.22338C25.7639 5.24405 25.706 5.27751 25.6566 5.32167C25.6072 5.36584 25.5675 5.41974 25.54 5.47999L24.46 7.71999L20.88 14.34H11.78L11.61 14L8.71 7.71999L7.48 5.06999L6.39 2.70999C6.35668 2.63132 6.30297 2.56296 6.23442 2.51198C6.16586 2.461 6.08493 2.42924 6 2.41999H2.51C2.4448 2.41997 2.38026 2.43297 2.32015 2.45822C2.26004 2.48347 2.20557 2.52046 2.15993 2.56702C2.1143 2.61359 2.07842 2.66879 2.05439 2.7294C2.03036 2.79001 2.01867 2.8548 2.02 2.91999V4.56999C2.01867 4.63517 2.03036 4.69997 2.05439 4.76058C2.07842 4.82118 2.1143 4.87639 2.15993 4.92295C2.20557 4.96952 2.26004 5.00651 2.32015 5.03176C2.38026 5.057 2.4448 5.07 2.51 5.06999H4.61L9.28 15.07L7.53 18.36C7.26814 18.8355 7.15985 19.3805 7.22 19.92C7.3034 20.5774 7.62564 21.1811 8.12536 21.6163C8.62508 22.0515 9.26739 22.2877 9.93 22.28H24.87C24.9339 22.28 24.9971 22.2673 25.056 22.2425C25.1149 22.2178 25.1683 22.1815 25.213 22.1359C25.2577 22.0902 25.2928 22.0361 25.3164 21.9767C25.3399 21.9174 25.3513 21.8539 25.35 21.79V20.13C25.3513 20.0656 25.34 20.0017 25.3166 19.9417C25.2931 19.8817 25.2582 19.827 25.2136 19.7805C25.169 19.7341 25.1157 19.6969 25.0568 19.6711C24.9978 19.6453 24.9344 19.6313 24.87 19.63H10.34C10.2955 19.6328 10.2508 19.6263 10.209 19.6108C10.1671 19.5954 10.129 19.5713 10.097 19.5403C10.0649 19.5092 10.0398 19.4717 10.0231 19.4304C10.0064 19.389 9.99852 19.3446 10 19.3Z" />
</svg>',
		),

		array(
			'name'   => __( 'Checkout', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wccheckout',
			'id'     => 35,
			'icon'   => '<svg class="sp-w-6 sp-fill-current "   viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M8.90441 23.8719C9.36486 23.5642 9.90621 23.4 10.46 23.4C10.8281 23.3987 11.1928 23.4702 11.5331 23.6104C11.8734 23.7507 12.1826 23.9569 12.4428 24.2172C12.7031 24.4774 12.9093 24.7866 13.0496 25.1269C13.1898 25.4672 13.2613 25.8319 13.26 26.2C13.26 26.7538 13.0958 27.2951 12.7881 27.7556C12.4804 28.2161 12.0431 28.5749 11.5315 28.7869C11.0199 28.9988 10.4569 29.0542 9.91375 28.9462C9.3706 28.8382 8.87169 28.5715 8.4801 28.1799C8.08852 27.7883 7.82184 27.2894 7.7138 26.7463C7.60576 26.2031 7.66121 25.6401 7.87314 25.1285C8.08506 24.6169 8.44395 24.1796 8.90441 23.8719ZM22.9044 23.8719C23.3649 23.5642 23.9062 23.4 24.46 23.4H24.43C24.8002 23.396 25.1675 23.4655 25.5107 23.6045C25.8539 23.7434 26.1661 23.949 26.4293 24.2094C26.6925 24.4698 26.9014 24.7798 27.044 25.1215C27.1866 25.4632 27.26 25.8298 27.26 26.2C27.26 26.7538 27.0958 27.2951 26.7881 27.7556C26.4804 28.2161 26.0431 28.5749 25.5315 28.7869C25.0199 28.9988 24.4569 29.0542 23.9137 28.9462C23.3706 28.8382 22.8717 28.5715 22.4801 28.1799C22.0885 27.7883 21.8218 27.2894 21.7138 26.7463C21.6058 26.2031 21.6612 25.6401 21.8731 25.1285C22.0851 24.6169 22.4439 24.1796 22.9044 23.8719ZM23.9752 11.3809L25.26 7.43C25.2955 7.32386 25.2881 7.20807 25.2396 7.10724C25.191 7.00641 25.1051 6.92848 25 6.89L13.85 3.27C13.7426 3.23505 13.6257 3.24377 13.5246 3.2943C13.4236 3.34482 13.3465 3.43308 13.31 3.54L11.18 10.09C11.1613 10.1431 11.1535 10.1995 11.157 10.2557C11.1605 10.3119 11.1753 10.3669 11.2005 10.4172C11.2257 10.4676 11.2608 10.5124 11.3036 10.549C11.3465 10.5855 11.3963 10.6131 11.45 10.63L20.5645 13.6H12.6L12.42 13.22L9.29 6.6L8 3.8L6.79 1.3C6.74823 1.21053 6.68184 1.13481 6.59861 1.08168C6.51538 1.02855 6.41874 1.00022 6.32 1H2.61C2.46944 1 2.33463 1.05584 2.23524 1.15523C2.13584 1.25463 2.08 1.38944 2.08 1.53V3.28C2.07999 3.34914 2.09376 3.41758 2.12052 3.48133C2.14727 3.54508 2.18647 3.60286 2.23582 3.65128C2.28518 3.6997 2.34369 3.73779 2.40793 3.76332C2.47218 3.78886 2.54088 3.80133 2.61 3.8H4.88L9.88 14.43L8 17.86C7.71649 18.357 7.60077 18.9321 7.67 19.5C7.76359 20.2049 8.11465 20.8503 8.6556 21.3119C9.19656 21.7734 9.88914 22.0185 10.6 22H26.7C26.8406 22 26.9754 21.9442 27.0748 21.8448C27.1742 21.7454 27.23 21.6106 27.23 21.47V19.72C27.23 19.6509 27.2162 19.5824 27.1895 19.5187C27.1627 19.4549 27.1235 19.3971 27.0742 19.3487C27.0248 19.3003 26.9663 19.2622 26.9021 19.2367C26.8378 19.2111 26.7691 19.1987 26.7 19.2H11.05C10.9572 19.2 10.8682 19.1631 10.8025 19.0975C10.7369 19.0318 10.7 18.9428 10.7 18.85V18.68L12 16.4H22.41C22.9047 16.4058 23.3919 16.279 23.8209 16.0328C24.25 15.7866 24.6054 15.43 24.85 15L27.85 10.89C27.8833 10.8297 27.9043 10.7634 27.9118 10.6949C27.9192 10.6264 27.913 10.5571 27.8935 10.4911C27.8739 10.425 27.8415 10.3635 27.798 10.3101C27.7544 10.2567 27.7008 10.2125 27.64 10.18L26 9.24C25.9381 9.2058 25.8698 9.18461 25.7994 9.17771C25.7289 9.17082 25.6579 9.17837 25.5905 9.1999C25.5231 9.22143 25.4608 9.25649 25.4074 9.30293C25.354 9.34938 25.3107 9.40623 25.28 9.47L23.9752 11.3809ZM22.45 13.31L24.31 7.58L14 4.22L12.13 10L22.45 13.31ZM21.49 8.9C21.5728 8.92615 21.6496 8.96839 21.7161 9.02429C21.7825 9.08019 21.8373 9.14865 21.8773 9.22576C21.9172 9.30286 21.9415 9.38709 21.9489 9.47362C21.9562 9.56015 21.9464 9.64727 21.92 9.73C21.863 9.89385 21.7446 10.0292 21.5898 10.1075C21.435 10.1858 21.2558 10.2011 21.09 10.15C21.0489 10.137 21.0092 10.1201 20.9716 10.0994C21.1255 9.93458 21.2415 9.73681 21.31 9.52C21.3718 9.32899 21.3948 9.12758 21.3778 8.92756C21.3762 8.90889 21.3743 8.89026 21.372 8.87169C21.412 8.87741 21.4515 8.88687 21.49 8.9ZM20.9954 8.0451C21.2484 7.99146 21.5117 8.00314 21.76 8.08C21.9514 8.13924 22.1292 8.23573 22.2832 8.36393C22.4372 8.49214 22.5643 8.64952 22.6572 8.82703C22.7502 9.00453 22.8071 9.19867 22.8247 9.39825C22.8424 9.59784 22.8204 9.79894 22.76 9.99C22.6695 10.2763 22.4963 10.5294 22.2622 10.7173C22.0281 10.9053 21.7435 11.0197 21.4444 11.0462C21.1453 11.0726 20.8451 11.0098 20.5817 10.8659C20.43 10.783 20.2944 10.6753 20.1801 10.5481C20.1191 10.5612 20.0571 10.5706 19.9944 10.5762C19.6953 10.6026 19.3951 10.5398 19.1317 10.3959C18.8682 10.2519 18.6533 10.0331 18.514 9.76708C18.3748 9.50109 18.3174 9.19981 18.3492 8.90125C18.3809 8.60269 18.5004 8.32022 18.6925 8.08948C18.8846 7.85874 19.1408 7.69007 19.4286 7.60474C19.7165 7.5194 20.0232 7.52123 20.31 7.61C20.5022 7.66806 20.6808 7.76386 20.8355 7.89179C20.8926 7.93902 20.946 7.99028 20.9954 8.0451ZM20.1964 8.49823C20.1508 8.46973 20.1017 8.44675 20.05 8.43C19.968 8.402 19.8812 8.39069 19.7947 8.39673C19.7083 8.40277 19.6239 8.42604 19.5465 8.46517C19.4692 8.50431 19.4005 8.55851 19.3444 8.6246C19.2883 8.69069 19.246 8.76732 19.22 8.85C19.1788 8.97408 19.1754 9.10758 19.2103 9.23359C19.2451 9.35959 19.3165 9.47242 19.4156 9.55776C19.5146 9.64311 19.6367 9.69712 19.7665 9.71296C19.7783 9.71439 19.79 9.71551 19.8018 9.71631C19.7879 9.60234 19.7869 9.48659 19.7992 9.37125C19.8309 9.07269 19.9504 8.79022 20.1425 8.55948C20.1599 8.53855 20.1779 8.51813 20.1964 8.49823ZM16.29 6.75L14.7 6.23C14.5846 6.19544 14.4603 6.20749 14.3537 6.26359C14.2472 6.31968 14.1668 6.41533 14.13 6.53C14.1113 6.58646 14.104 6.64606 14.1085 6.70536C14.113 6.76466 14.1292 6.82248 14.1561 6.87548C14.1831 6.92849 14.2203 6.97562 14.2656 7.01416C14.3109 7.05269 14.3634 7.08187 14.42 7.1L16 7.62C16.1154 7.65541 16.24 7.64504 16.348 7.59105C16.456 7.53706 16.5391 7.44358 16.58 7.33C16.6149 7.2133 16.6031 7.0876 16.5472 6.9794C16.4912 6.8712 16.3954 6.78896 16.28 6.75H16.29ZM14.16 7.89999L16.58 8.67999C16.6828 8.72665 16.7648 8.80947 16.8105 8.9127C16.8562 9.01592 16.8623 9.13233 16.8277 9.23978C16.7932 9.34723 16.7203 9.43822 16.623 9.49542C16.5257 9.55262 16.4107 9.57204 16.3 9.54999L13.88 8.75999C13.8235 8.74161 13.7712 8.71228 13.7261 8.67369C13.681 8.63509 13.6439 8.58798 13.617 8.53506C13.59 8.48213 13.5738 8.42441 13.5692 8.3652C13.5645 8.306 13.5716 8.24646 13.59 8.18999C13.6084 8.13352 13.6377 8.08123 13.6763 8.0361C13.7149 7.99096 13.762 7.95387 13.8149 7.92694C13.8679 7.90001 13.9256 7.88377 13.9848 7.87915C14.044 7.87453 14.1035 7.88161 14.16 7.89999Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Cart', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wccart',
			'id'     => 36,
			'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M23.37 23.33C22.8166 23.332 22.2763 23.4979 21.8171 23.8067C21.358 24.1156 21.0007 24.5536 20.7903 25.0654C20.5799 25.5772 20.5259 26.1399 20.635 26.6824C20.7442 27.2248 21.0117 27.7228 21.4036 28.1134C21.7956 28.504 22.2945 28.7697 22.8374 28.8769C23.3803 28.9841 23.9428 28.9281 24.4538 28.7159C24.9649 28.5037 25.4016 28.1448 25.7088 27.6846C26.016 27.2243 26.18 26.6834 26.18 26.13C26.1813 25.7611 26.1095 25.3956 25.9686 25.0546C25.8277 24.7136 25.6207 24.404 25.3593 24.1436C25.098 23.8832 24.7876 23.6772 24.4461 23.5375C24.1047 23.3979 23.7389 23.3274 23.37 23.33ZM9.37 23.33C8.81621 23.33 8.27486 23.4942 7.8144 23.8019C7.35395 24.1096 6.99506 24.5469 6.78314 25.0585C6.57121 25.5701 6.51576 26.1331 6.6238 26.6762C6.73184 27.2194 6.99851 27.7183 7.3901 28.1099C7.78169 28.5015 8.2806 28.7682 8.82375 28.8762C9.36689 28.9842 9.92988 28.9288 10.4415 28.7169C10.9531 28.5049 11.3904 28.1461 11.6981 27.6856C12.0058 27.2251 12.17 26.6838 12.17 26.13C12.1713 25.7636 12.1005 25.4005 11.9615 25.0615C11.8225 24.7225 11.6181 24.4142 11.3599 24.1542C11.1018 23.8942 10.7949 23.6876 10.4569 23.5462C10.1189 23.4048 9.75639 23.3313 9.39 23.33H9.37Z" />
	<path d="M29 4.70999V5.18999C29.016 5.27592 29.016 5.36406 29 5.44999C28.9861 5.49589 28.9659 5.53963 28.94 5.57999C28.9206 5.62532 28.8972 5.66883 28.87 5.70999L23.82 14.88C23.5806 15.3174 23.2275 15.6821 22.798 15.9356C22.3686 16.189 21.8787 16.3218 21.38 16.32H11H10.94L9.67 18.61L9.62 18.78C9.6226 18.8737 9.66168 18.9627 9.72891 19.0281C9.79615 19.0935 9.88623 19.13 9.98 19.13H25.65C25.7906 19.13 25.9254 19.1858 26.0248 19.2852C26.1242 19.3846 26.18 19.5194 26.18 19.66V21.4C26.18 21.5406 26.1242 21.6754 26.0248 21.7748C25.9254 21.8742 25.7906 21.93 25.65 21.93H9.53C8.82028 21.9441 8.13004 21.6974 7.59003 21.2367C7.05003 20.7759 6.69777 20.1331 6.6 19.43C6.54061 18.8581 6.65936 18.2818 6.94 17.78L8.81 14.38V14.33L3.8 3.75999H1.52C1.44865 3.75876 1.37828 3.74313 1.31311 3.71404C1.24794 3.68496 1.18932 3.64301 1.14076 3.59071C1.09221 3.53842 1.05471 3.47685 1.03052 3.40971C1.00633 3.34257 0.99595 3.27124 1 3.19999V1.45999C0.999975 1.32114 1.05444 1.18783 1.15168 1.08872C1.24892 0.989606 1.38118 0.932612 1.52 0.929993H5.18C5.29158 0.930348 5.40093 0.961303 5.49614 1.01949C5.59135 1.07767 5.66878 1.16086 5.72 1.25999L6.88 3.72999L8.21 6.52999L11.35 13.16L11.53 13.53H21.32H21.37L25.21 6.52999L25.41 6.11999H13.41C13.3404 6.12132 13.2712 6.10892 13.2064 6.0835C13.1416 6.05808 13.0824 6.02015 13.0323 5.97186C12.9821 5.92357 12.942 5.86587 12.9141 5.80207C12.8863 5.73826 12.8713 5.6696 12.87 5.59999V4.18999C12.8713 4.12039 12.8863 4.05172 12.9141 3.98792C12.942 3.92411 12.9821 3.86642 13.0323 3.81813C13.0824 3.76984 13.1416 3.7319 13.2064 3.70648C13.2712 3.68107 13.3404 3.66867 13.41 3.66999H27.93C28.2094 3.66731 28.4786 3.77507 28.679 3.96983C28.8794 4.16459 28.9947 4.4306 29 4.70999Z" />
	</svg>
	',
		),

		array(
			'name'   => __( 'Products Grid', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wccustomproductsgrid',
			'id'     => 37,
			'icon'   => '
	<svg class="sp-w-6 sp-fill-current " viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M16.44 8.50999H23.65V11.39H16.44V8.50999ZM16.44 18.61H23.65V21.49H16.44V18.61ZM25.1 1.99999H4.9C4.5188 1.99867 4.1411 2.07277 3.78866 2.21804C3.43622 2.36332 3.116 2.57688 2.84645 2.84643C2.57689 3.11598 2.36333 3.4362 2.21806 3.78864C2.07279 4.14108 1.99868 4.51878 2 4.89999V25.1C1.99868 25.4812 2.07279 25.8589 2.21806 26.2113C2.36333 26.5638 2.57689 26.884 2.84645 27.1535C3.116 27.4231 3.43622 27.6367 3.78866 27.7819C4.1411 27.9272 4.5188 28.0013 4.9 28H25.1C25.4812 28.0013 25.8589 27.9272 26.2113 27.7819C26.5638 27.6367 26.884 27.4231 27.1536 27.1535C27.4231 26.884 27.6367 26.5638 27.7819 26.2113C27.9272 25.8589 28.0013 25.4812 28 25.1V4.89999C28.0013 4.51878 27.9272 4.14108 27.7819 3.78864C27.6367 3.4362 27.4231 3.11598 27.1536 2.84643C26.884 2.57688 26.5638 2.36332 26.2113 2.21804C25.8589 2.07277 25.4812 1.99867 25.1 1.99999ZM25.1 25.08H4.9V4.89999H25.1V25.08ZM13.56 6.34999H6.35V13.56H13.56V6.34999ZM12.12 12.12H7.79V7.78999H12.12V12.12ZM13.56 16.44H6.35V23.65H13.56V16.44ZM12.12 22.21H7.79V17.88H12.12V22.21Z" />
	</svg>',
		),

		array(
			'name'   => __( 'Recent Products', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wcrecentproductsgrid',
			'id'     => 42,
			'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
	<path d="M13.56 9.23V16.44L19.69 20.08L20.8 18.23L15.72 15.23V9.23H13.56ZM28 12.12V2L24.17 5.83C22.0377 3.70809 19.2355 2.39134 16.2411 2.10417C13.2467 1.817 10.2453 2.57719 7.74859 4.25518C5.25189 5.93316 3.41438 8.42507 2.54927 11.3062C1.68416 14.1873 1.84499 17.2792 3.00434 20.055C4.1637 22.8308 6.24982 25.1186 8.90714 26.5285C11.5645 27.9384 14.6285 28.3831 17.577 27.7868C20.5255 27.1906 23.1759 25.5902 25.0765 23.2585C26.9772 20.9268 28.0104 18.0082 28 15H25.1C25.111 17.3387 24.3109 19.6088 22.8359 21.4237C21.361 23.2387 19.3024 24.4861 17.0109 24.9536C14.7195 25.421 12.3368 25.0796 10.2688 23.9875C8.20076 22.8953 6.57536 21.1199 5.66944 18.9639C4.76351 16.8078 4.6331 14.4043 5.30043 12.1628C5.96775 9.92135 7.39152 7.98057 9.32922 6.67107C11.2669 5.36156 13.5987 4.76434 15.9273 4.98113C18.2559 5.19792 20.4373 6.21531 22.1 7.86L17.84 12.12H28Z" />
	</svg>',
		),

		array(
			'name'   => __( 'Sale Products', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wcsaleproductsgrid',
			'id'     => 40,
			'icon'   => '<svg class="sp-w-6 sp-fill-current "  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path fill-rule="evenodd" clip-rule="evenodd" d="M15 4.3C17.1163 4.3 19.185 4.92754 20.9446 6.10328C22.7042 7.27901 24.0757 8.95012 24.8855 10.9053C25.6954 12.8605 25.9073 15.0119 25.4944 17.0875C25.0815 19.1631 24.0625 21.0696 22.566 22.566C21.0696 24.0625 19.1631 25.0815 17.0875 25.4944C15.0119 25.9073 12.8605 25.6954 10.9053 24.8855C8.95012 24.0757 7.27901 22.7042 6.10328 20.9446C4.92755 19.185 4.30001 17.1163 4.30001 15C4.30265 12.163 5.43082 9.44295 7.43689 7.43688C9.44295 5.43082 12.163 4.30265 15 4.3ZM15 2C12.4288 2 9.91543 2.76244 7.77759 4.1909C5.63975 5.61935 3.97351 7.64968 2.98957 10.0251C2.00563 12.4006 1.74819 15.0144 2.2498 17.5362C2.75141 20.0579 3.98953 22.3743 5.80762 24.1924C7.6257 26.0105 9.94208 27.2486 12.4638 27.7502C14.9856 28.2518 17.5995 27.9944 19.9749 27.0104C22.3503 26.0265 24.3807 24.3603 25.8091 22.2224C27.2376 20.0846 28 17.5712 28 15C28 11.5522 26.6304 8.24558 24.1924 5.80761C21.7544 3.36964 18.4478 2 15 2ZM6.23 17.16V15.91C6.44916 16.0962 6.69975 16.2418 6.97 16.34C7.22889 16.4379 7.50322 16.4887 7.78 16.49C7.91827 16.4914 8.05611 16.4745 8.19 16.44C8.29585 16.4165 8.39717 16.376 8.49 16.32C8.56399 16.2758 8.62584 16.214 8.67 16.14C8.7216 16.065 8.74923 15.9761 8.74923 15.885C8.74923 15.7939 8.7216 15.705 8.67 15.63C8.60472 15.5331 8.51948 15.4513 8.42 15.39C8.2992 15.3041 8.1682 15.2336 8.03 15.18L7.55 14.97C7.16689 14.8318 6.82353 14.6018 6.55 14.3C6.3687 14.0587 6.25934 13.771 6.23457 13.4702C6.2098 13.1694 6.27062 12.8677 6.41 12.6C6.51312 12.3853 6.67199 12.2023 6.87 12.07C7.0811 11.9245 7.31906 11.8225 7.57 11.77C7.84529 11.7048 8.12711 11.6713 8.41 11.67C8.67124 11.6677 8.93219 11.6878 9.19 11.73C9.40179 11.7611 9.60964 11.8147 9.81 11.89V13.07C9.71588 12.998 9.61135 12.9406 9.5 12.9C9.39086 12.8464 9.27705 12.8029 9.16 12.77L8.81 12.7C8.70022 12.6903 8.58979 12.6903 8.48 12.7C8.35048 12.6842 8.21952 12.6842 8.09 12.7C7.98376 12.7166 7.88182 12.754 7.79 12.81C7.71602 12.8542 7.65416 12.916 7.61 12.99C7.56303 13.0574 7.53854 13.1379 7.54 13.22C7.53564 13.3087 7.56021 13.3965 7.61 13.47C7.66638 13.5552 7.73749 13.6297 7.82 13.69C7.92967 13.7597 8.04318 13.8231 8.16 13.88L8.6 14.08C8.80768 14.1638 9.00832 14.2642 9.2 14.38C9.36895 14.4746 9.52379 14.5924 9.66 14.73C9.78755 14.8615 9.88631 15.0182 9.95 15.19C10.0221 15.3816 10.0561 15.5854 10.05 15.79C10.0624 16.0604 10.0038 16.3293 9.88 16.57C9.76295 16.7818 9.59443 16.9606 9.39 17.09C9.17547 17.2248 8.93832 17.3197 8.69 17.37C8.40743 17.431 8.11908 17.4612 7.83 17.46C7.53817 17.46 7.24695 17.4332 6.96 17.38C6.70689 17.3443 6.46072 17.2701 6.23 17.16ZM14.53 17.38H15.9L13.88 11.78H12.38L10.38 17.38H11.73L12.13 16.13H14.13L14.53 17.38ZM13.24 13.28L13.84 15.16H12.44L13.05 13.27C13.0984 13.1106 13.1286 12.9462 13.14 12.78C13.1539 12.95 13.1875 13.1177 13.24 13.28ZM19.94 17.38H16.6V11.78H17.86V16.36H19.94V17.38ZM20.69 17.38H24.08V16.36H21.95V15.07H23.76V14.07H21.92V12.78H23.92V11.78H20.69V17.38Z" />
        </svg>',
		),

		array(
			'name'   => __( 'Best Selling Products', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wcbestsellingproductsgrid',
			'id'     => 41,
			'icon'   => '<svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><path d="M0 0h24v24H0V0z" fill="none"/><path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V5h14v14zM7 10h2v7H7zm4-3h2v10h-2zm4 6h2v4h-2z"/></svg> ',
		),

		array(
			'name'   => __( 'Featured Products', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wcfeaturedproductsgrid',
			'id'     => 39,
			'icon'   => ' <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24"  viewBox="0 0 24 24" class="sp-w-6 sp-fill-current "><rect fill="none" height="24" width="24"/><path d="M19,5h-2V3H7v2H5C3.9,5,3,5.9,3,7v1c0,2.55,1.92,4.63,4.39,4.94c0.63,1.5,1.98,2.63,3.61,2.96V19H7v2h10v-2h-4v-3.1 c1.63-0.33,2.98-1.46,3.61-2.96C19.08,12.63,21,10.55,21,8V7C21,5.9,20.1,5,19,5z M5,8V7h2v3.82C5.84,10.4,5,9.3,5,8z M12,14 c-1.65,0-3-1.35-3-3V5h6v6C15,12.65,13.65,14,12,14z M19,8c0,1.3-0.84,2.4-2,2.82V7h2V8z"/></svg>',
		),

		array(
			'name'   => __( 'Top Rated Products', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'wc',
			'type'   => 'wctopratedproductsgrid',
			'id'     => 43,
			'icon'   => '
        <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 24 24" class="sp-w-6 sp-fill-current " viewBox="0 0 24 24" ><g><rect fill="none" height="24" width="24"/></g><g><g><path d="M17,10.43V2H7v8.43c0,0.35,0.18,0.68,0.49,0.86l4.18,2.51l-0.99,2.34l-3.41,0.29l2.59,2.24L9.07,22L12,20.23L14.93,22 l-0.78-3.33l2.59-2.24l-3.41-0.29l-0.99-2.34l4.18-2.51C16.82,11.11,17,10.79,17,10.43z M11,11.07l-2-1.2V4h2V11.07z M15,9.87 l-2,1.2V4h2V9.87z"/></g></g></svg>',
		),

		array(
			'name'   => __( 'Posts', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'posts',
			'id'     => 47,
			'icon'   => '
			<svg viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current">
			<path clip-rule="evenodd" d="m1 27.5v-25c0-.39782.15804-.77936.43934-1.06066s.66284-.43934 1.06066-.43934h25c.3978 0 .7794.15804 1.0607.43934s.4393.66284.4393 1.06066v25c0 .3978-.158.7794-.4393 1.0607s-.6629.4393-1.0607.4393h-25c-.39782 0-.77936-.158-1.06066-.4393s-.43934-.6629-.43934-1.0607zm26-.5v-19h-24v19zm-24-21v-3h24v3zm12.67 5.11h7.66c.176 0 .3449.0692.4703.1927.1253.1235.1971.2913.1997.4673 0 .1777-.0706.3481-.1962.4738-.1257.1256-.2961.1962-.4738.1962h-7.66c-.1777 0-.3481-.0706-.4738-.1962-.1256-.1257-.1962-.2961-.1962-.4738.0026-.176.0744-.3438.1997-.4673.1254-.1235.2943-.1927.4703-.1927zm7.66 2.66h-7.66c-.1777 0-.3481.0706-.4738.1962-.1256.1257-.1962.2961-.1962.4738s.0706.3481.1962.4738c.1257.1256.2961.1962.4738.1962h7.66c.1777 0 .3481-.0706.4738-.1962.1256-.1257.1962-.2961.1962-.4738s-.0706-.3481-.1962-.4738c-.1257-.1256-.2961-.1962-.4738-.1962zm-10.72-3.66h-6.21999c-.05159-.0014-.10292.0078-.15086.0269s-.09148.0478-.12797.0843c-.0365.0365-.06517.08-.08428.1279-.01912.048-.02826.0993-.02689.1509v5.11c0 .1034.04109.2026.11423.2758.07314.0731.17234.1142.27577.1142h6.21999c.1034 0 .2026-.0411.2758-.1142.0731-.0732.1142-.1724.1142-.2758v-5.11c.0014-.0516-.0078-.1029-.0269-.1509-.0191-.0479-.0478-.0914-.0843-.1279-.0364-.0365-.08-.0652-.1279-.0843-.048-.0191-.0993-.0283-.1509-.0269zm-5.82999.78h5.43999v.63l-1.94 2-1.59999-1.61-1.9 2.56zm.39 4.32 1.59-2.15 1.51999 1.53 1.94-2v2.58zm16.15999 4.79h-7.66c-.1777 0-.3481.0706-.4738.1962-.1256.1257-.1962.2961-.1962.4738.0026.176.0744.3438.1997.4673.1254.1235.2943.1927.4703.1927h7.66c.176 0 .3449-.0692.4703-.1927.1253-.1235.1971-.2913.1997-.4673 0-.088-.0173-.1751-.051-.2564s-.083-.1551-.1452-.2174c-.0623-.0622-.1361-.1115-.2174-.1452s-.1684-.051-.2564-.051zm-7.66 2.67h7.66c.176 0 .3449.0692.4703.1927.1253.1235.1971.2913.1997.4673 0 .1777-.0706.3481-.1962.4738-.1257.1256-.2961.1962-.4738.1962h-7.66c-.1777 0-.3481-.0706-.4738-.1962-.1256-.1257-.1962-.2961-.1962-.4738.0026-.176.0744-.3438.1997-.4673.1254-.1235.2943-.1927.4703-.1927zm-9.27999-3.67h6.21999c.1034 0 .2026.0411.2758.1142.0731.0732.1142.1724.1142.2758v5.11c.0014.0516-.0078.1029-.0269.1509-.0191.0479-.0478.0914-.0843.1279-.0364.0365-.08.0652-.1279.0843-.048.0191-.0993.0283-.1509.0269h-6.21999c-.05159.0014-.10292-.0078-.15086-.0269s-.09148-.0478-.12797-.0843c-.0365-.0365-.06517-.08-.08428-.1279-.01912-.048-.02826-.0993-.02689-.1509v-5.11c0-.1034.04109-.2026.11423-.2758.07314-.0731.17234-.1142.27577-.1142zm5.82999.79h-5.43999v3.57l1.9-2.56 1.59999 1.61 1.94-2zm-3.45999 2.21-1.59 2.11 5.04999.01v-2.59l-1.94 2z"  fill-rule="evenodd"/></svg>',
		),

		array(
			'name'   => __( 'Posts', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'posts',
			'id'     => 47,
			'icon'   => '
            <svg viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current">
            <path clip-rule="evenodd" d="m1 27.5v-25c0-.39782.15804-.77936.43934-1.06066s.66284-.43934 1.06066-.43934h25c.3978 0 .7794.15804 1.0607.43934s.4393.66284.4393 1.06066v25c0 .3978-.158.7794-.4393 1.0607s-.6629.4393-1.0607.4393h-25c-.39782 0-.77936-.158-1.06066-.4393s-.43934-.6629-.43934-1.0607zm26-.5v-19h-24v19zm-24-21v-3h24v3zm12.67 5.11h7.66c.176 0 .3449.0692.4703.1927.1253.1235.1971.2913.1997.4673 0 .1777-.0706.3481-.1962.4738-.1257.1256-.2961.1962-.4738.1962h-7.66c-.1777 0-.3481-.0706-.4738-.1962-.1256-.1257-.1962-.2961-.1962-.4738.0026-.176.0744-.3438.1997-.4673.1254-.1235.2943-.1927.4703-.1927zm7.66 2.66h-7.66c-.1777 0-.3481.0706-.4738.1962-.1256.1257-.1962.2961-.1962.4738s.0706.3481.1962.4738c.1257.1256.2961.1962.4738.1962h7.66c.1777 0 .3481-.0706.4738-.1962.1256-.1257.1962-.2961.1962-.4738s-.0706-.3481-.1962-.4738c-.1257-.1256-.2961-.1962-.4738-.1962zm-10.72-3.66h-6.21999c-.05159-.0014-.10292.0078-.15086.0269s-.09148.0478-.12797.0843c-.0365.0365-.06517.08-.08428.1279-.01912.048-.02826.0993-.02689.1509v5.11c0 .1034.04109.2026.11423.2758.07314.0731.17234.1142.27577.1142h6.21999c.1034 0 .2026-.0411.2758-.1142.0731-.0732.1142-.1724.1142-.2758v-5.11c.0014-.0516-.0078-.1029-.0269-.1509-.0191-.0479-.0478-.0914-.0843-.1279-.0364-.0365-.08-.0652-.1279-.0843-.048-.0191-.0993-.0283-.1509-.0269zm-5.82999.78h5.43999v.63l-1.94 2-1.59999-1.61-1.9 2.56zm.39 4.32 1.59-2.15 1.51999 1.53 1.94-2v2.58zm16.15999 4.79h-7.66c-.1777 0-.3481.0706-.4738.1962-.1256.1257-.1962.2961-.1962.4738.0026.176.0744.3438.1997.4673.1254.1235.2943.1927.4703.1927h7.66c.176 0 .3449-.0692.4703-.1927.1253-.1235.1971-.2913.1997-.4673 0-.088-.0173-.1751-.051-.2564s-.083-.1551-.1452-.2174c-.0623-.0622-.1361-.1115-.2174-.1452s-.1684-.051-.2564-.051zm-7.66 2.67h7.66c.176 0 .3449.0692.4703.1927.1253.1235.1971.2913.1997.4673 0 .1777-.0706.3481-.1962.4738-.1257.1256-.2961.1962-.4738.1962h-7.66c-.1777 0-.3481-.0706-.4738-.1962-.1256-.1257-.1962-.2961-.1962-.4738.0026-.176.0744-.3438.1997-.4673.1254-.1235.2943-.1927.4703-.1927zm-9.27999-3.67h6.21999c.1034 0 .2026.0411.2758.1142.0731.0732.1142.1724.1142.2758v5.11c.0014.0516-.0078.1029-.0269.1509-.0191.0479-.0478.0914-.0843.1279-.0364.0365-.08.0652-.1279.0843-.048.0191-.0993.0283-.1509.0269h-6.21999c-.05159.0014-.10292-.0078-.15086-.0269s-.09148-.0478-.12797-.0843c-.0365-.0365-.06517-.08-.08428-.1279-.01912-.048-.02826-.0993-.02689-.1509v-5.11c0-.1034.04109-.2026.11423-.2758.07314-.0731.17234-.1142.27577-.1142zm5.82999.79h-5.43999v3.57l1.9-2.56 1.59999 1.61 1.94-2zm-3.45999 2.21-1.59 2.11 5.04999.01v-2.59l-1.94 2z"  fill-rule="evenodd"/></svg>',
		),

		//$wordpress_widgets

		array(
			'name'   => __( 'Post Title', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'posttitle',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.00003 23V2.42999C7.00003 2.03217 7.15806 1.65064 7.43937 1.36933C7.72067 1.08803 8.10221 0.929993 8.50003 0.929993H26.5C26.8979 0.929993 27.2794 1.08803 27.5607 1.36933C27.842 1.65064 28 2.03217 28 2.42999V24.82C28.0134 25.3536 27.9198 25.8846 27.7247 26.3815C27.5297 26.8784 27.2372 27.3312 26.8644 27.7133C26.4916 28.0954 26.0462 28.399 25.5542 28.6062C25.0623 28.8135 24.5338 28.9202 24 28.92H5.00003C4.46622 28.9202 3.93778 28.8135 3.44584 28.6062C2.9539 28.399 2.50842 28.0954 2.13565 27.7133C1.76288 27.3312 1.47036 26.8784 1.27532 26.3815C1.08029 25.8846 0.986684 25.3536 1.00003 24.82V24H6.00003C6.26525 24 6.5196 23.8946 6.70714 23.7071C6.89467 23.5196 7.00003 23.2652 7.00003 23ZM3.61477 26.8323C4.01691 27.1267 4.50164 27.2869 5.00003 27.29H21C20.5576 26.8178 20.2172 26.2595 20 25.65H2.76003C2.91354 26.1242 3.21262 26.5379 3.61477 26.8323ZM25.4142 25.3442C25.7893 24.9691 26 24.4604 26 23.93V23.53V2.92999H9.00003V22.93C9.00003 23.1952 9.10539 23.4496 9.29292 23.6371C9.48046 23.8246 9.73481 23.93 10 23.93H22C22 24.4604 22.2107 24.9691 22.5858 25.3442C22.9609 25.7193 23.4696 25.93 24 25.93C24.5305 25.93 25.0392 25.7193 25.4142 25.3442ZM14.7 19.18V19.88C14.7881 19.8758 14.8757 19.8716 14.9626 19.8674C15.9116 19.822 16.7871 19.78 17.52 19.78C18.32 19.78 19.21 19.81 20.32 19.86V19.16C19.9086 19.1764 19.497 19.1292 19.1 19.02C19.0357 18.9866 18.9793 18.9399 18.9344 18.883C18.8896 18.8261 18.8574 18.7603 18.84 18.69C18.7542 17.9533 18.7241 17.2112 18.75 16.47V11.35V9.01H20.02C20.3913 9.01 20.7179 9.03087 21.0144 9.04982C21.2609 9.06557 21.4866 9.08 21.7 9.08C21.7968 9.0771 21.8929 9.09769 21.98 9.14C22.0421 9.25428 22.0796 9.38033 22.09 9.51C22.1532 9.93061 22.1899 10.3548 22.2 10.78H22.91V8.91C22.9246 8.60533 22.9546 8.30161 23 8L22.91 7.91C22.65 7.97 22.38 7.97 22.12 7.97H19.23H15.77H12.93C12.7916 7.96538 12.6576 7.95227 12.5267 7.93947C12.3739 7.92451 12.2255 7.91 12.08 7.91L12 8C12 8.17593 12.0354 8.35187 12.0661 8.50404C12.0894 8.62 12.11 8.72215 12.11 8.8V10.8H12.82C12.8242 10.3504 12.8677 9.90202 12.95 9.46C12.9585 9.35337 12.9928 9.25041 13.05 9.16C13.1537 9.11318 13.2662 9.0893 13.38 9.09C13.8533 9.05 14.3933 9.03 15 9.03H16.27V11.37V16.45C16.2964 17.1879 16.2663 17.9267 16.18 18.66C16.1652 18.7326 16.1341 18.801 16.0891 18.8599C16.0441 18.9188 15.9862 18.9667 15.92 19C15.5251 19.1227 15.1135 19.1834 14.7 19.18Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Post Content', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postcontent',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.00003 2.42999V23C7.00003 23.2652 6.89467 23.5196 6.70714 23.7071C6.5196 23.8946 6.26525 24 6.00003 24H1.00003V24.82C0.986684 25.3536 1.08029 25.8846 1.27532 26.3815C1.47036 26.8784 1.76288 27.3312 2.13565 27.7133C2.50842 28.0954 2.9539 28.399 3.44584 28.6062C3.93778 28.8135 4.46622 28.9202 5.00003 28.92H24C24.5338 28.9202 25.0623 28.8135 25.5542 28.6062C26.0462 28.399 26.4916 28.0954 26.8644 27.7133C27.2372 27.3312 27.5297 26.8784 27.7247 26.3815C27.9198 25.8846 28.0134 25.3536 28 24.82V2.42999C28 2.03217 27.842 1.65064 27.5607 1.36933C27.2794 1.08803 26.8979 0.929993 26.5 0.929993H8.50003C8.10221 0.929993 7.72067 1.08803 7.43937 1.36933C7.15806 1.65064 7.00003 2.03217 7.00003 2.42999ZM5.00003 27.29C4.50164 27.2869 4.01691 27.1267 3.61477 26.8323C3.21262 26.5379 2.91354 26.1242 2.76003 25.65H20C20.2172 26.2595 20.5576 26.8178 21 27.29H5.00003ZM26 23.93C26 24.4604 25.7893 24.9691 25.4142 25.3442C25.0392 25.7193 24.5305 25.93 24 25.93C23.4696 25.93 22.9609 25.7193 22.5858 25.3442C22.2107 24.9691 22 24.4604 22 23.93H10C9.73481 23.93 9.48046 23.8246 9.29292 23.6371C9.10539 23.4496 9.00003 23.1952 9.00003 22.93V2.92999H26V23.53V23.93ZM22.33 16.93H12.67C12.582 16.93 12.4949 16.9473 12.4136 16.981C12.3323 17.0147 12.2585 17.064 12.1962 17.1262C12.134 17.1884 12.0847 17.2623 12.051 17.3436C12.0173 17.4249 12 17.512 12 17.6C12 17.7777 12.0706 17.9481 12.1962 18.0738C12.3219 18.1994 12.4923 18.27 12.67 18.27H22.33C22.418 18.27 22.5051 18.2527 22.5864 18.219C22.6677 18.1853 22.7415 18.136 22.8038 18.0738C22.866 18.0115 22.9153 17.9377 22.949 17.8564C22.9827 17.7751 23 17.688 23 17.6C23 17.512 22.9827 17.4249 22.949 17.3436C22.9153 17.2623 22.866 17.1884 22.8038 17.1262C22.7415 17.064 22.6677 17.0147 22.5864 16.981C22.5051 16.9473 22.418 16.93 22.33 16.93ZM22.33 19.6H12.67C12.4923 19.6 12.3219 19.6706 12.1962 19.7962C12.0706 19.9219 12 20.0923 12 20.27C12.0026 20.446 12.0744 20.6138 12.1997 20.7373C12.3251 20.8608 12.494 20.93 12.67 20.93H22.33C22.506 20.93 22.6749 20.8608 22.8003 20.7373C22.9256 20.6138 22.9974 20.446 23 20.27C23 20.182 22.9827 20.0949 22.949 20.0136C22.9153 19.9323 22.866 19.8585 22.8038 19.7962C22.7415 19.734 22.6677 19.6847 22.5864 19.651C22.5051 19.6173 22.418 19.6 22.33 19.6ZM13 14.05V14.62L14.59 14.58H16.19V14.01C15.8516 14.0273 15.5128 13.9833 15.19 13.88C15.1527 13.8551 15.1228 13.8205 15.1035 13.7801C15.0841 13.7396 15.076 13.6947 15.08 13.65C15.1452 13.2411 15.2593 12.8416 15.42 12.46L15.73 11.64H19.34L19.93 13.15C20.0171 13.3289 20.0713 13.5219 20.09 13.72C20.0922 13.7589 20.0829 13.7977 20.0634 13.8314C20.0439 13.8652 20.0149 13.8925 19.98 13.91C19.6715 13.9793 19.3561 14.0128 19.04 14.01V14.58H21.46H23.37V14.01H23.07C22.9371 14.026 22.8029 14.026 22.67 14.01C22.6183 13.9934 22.5706 13.9661 22.53 13.93C22.4774 13.8773 22.4335 13.8165 22.4 13.75L22.12 13.12L21.69 12.12L18.61 4.92999H17.61L17 6.49999L15.16 10.93C15.1291 11.0064 15.0991 11.0806 15.07 11.1525C14.7791 11.8713 14.5791 12.3655 14.47 12.62C14.21 13.23 14.06 13.58 14 13.67C13.9593 13.7462 13.9089 13.8168 13.85 13.88C13.7966 13.9217 13.7354 13.9522 13.67 13.97C13.4485 14.0102 13.2247 14.0369 13 14.05ZM17.47 10.89H16L17.46 7.33999L18.89 10.89H17.47Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Post Excerpt', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postexcerpt',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.00003 23V2.42999C7.00003 2.03217 7.15806 1.65064 7.43937 1.36933C7.72067 1.08803 8.10221 0.929993 8.50003 0.929993H26.5C26.8979 0.929993 27.2794 1.08803 27.5607 1.36933C27.842 1.65064 28 2.03217 28 2.42999V24.82C28.0134 25.3536 27.9198 25.8846 27.7247 26.3815C27.5297 26.8784 27.2372 27.3312 26.8644 27.7133C26.4916 28.0954 26.0462 28.399 25.5542 28.6062C25.0623 28.8135 24.5338 28.9202 24 28.92H5.00003C4.46622 28.9202 3.93778 28.8135 3.44584 28.6062C2.9539 28.399 2.50842 28.0954 2.13565 27.7133C1.76288 27.3312 1.47036 26.8784 1.27532 26.3815C1.08029 25.8846 0.986684 25.3536 1.00003 24.82V24H6.00003C6.26525 24 6.5196 23.8946 6.70714 23.7071C6.89467 23.5196 7.00003 23.2652 7.00003 23ZM3.61477 26.8323C4.01691 27.1267 4.50164 27.2869 5.00003 27.29H21C20.5576 26.8178 20.2172 26.2595 20 25.65H2.76003C2.91354 26.1242 3.21262 26.5379 3.61477 26.8323ZM25.4142 25.3442C25.7893 24.9691 26 24.4604 26 23.93V23.53V2.92999H9.00003V22.93C9.00003 23.1952 9.10539 23.4496 9.29292 23.6371C9.48046 23.8246 9.73481 23.93 10 23.93H22C22 24.4604 22.2107 24.9691 22.5858 25.3442C22.9609 25.7193 23.4696 25.93 24 25.93C24.5305 25.93 25.0392 25.7193 25.4142 25.3442ZM11.67 5.92999H21.33C21.418 5.92999 21.5051 5.94732 21.5864 5.98099C21.6677 6.01466 21.7415 6.06402 21.8038 6.12623C21.866 6.18845 21.9153 6.26231 21.949 6.3436C21.9827 6.42488 22 6.51201 22 6.59999C22 6.68798 21.9827 6.7751 21.949 6.85639C21.9153 6.93768 21.866 7.01154 21.8038 7.07375C21.7415 7.13597 21.6677 7.18532 21.5864 7.21899C21.5051 7.25266 21.418 7.26999 21.33 7.26999H11.67C11.4923 7.26999 11.3219 7.1994 11.1962 7.07375C11.0706 6.9481 11 6.77769 11 6.59999C11 6.4223 11.0706 6.25188 11.1962 6.12623C11.3219 6.00058 11.4923 5.92999 11.67 5.92999ZM11.67 8.92999H23.33C23.5077 8.92999 23.6781 9.00058 23.8038 9.12623C23.9294 9.25188 24 9.4223 24 9.59999C24 9.77769 23.9294 9.9481 23.8038 10.0738C23.6781 10.1994 23.5077 10.27 23.33 10.27H11.67C11.4923 10.27 11.3219 10.1994 11.1962 10.0738C11.0706 9.9481 11 9.77769 11 9.59999C11 9.4223 11.0706 9.25188 11.1962 9.12623C11.3219 9.00058 11.4923 8.92999 11.67 8.92999ZM21.33 11.93H11.67C11.4923 11.93 11.3219 12.0006 11.1962 12.1262C11.0706 12.2519 11 12.4223 11 12.6C11 12.7777 11.0706 12.9481 11.1962 13.0738C11.3219 13.1994 11.4923 13.27 11.67 13.27H21.33C21.418 13.27 21.5051 13.2527 21.5864 13.219C21.6677 13.1853 21.7415 13.136 21.8038 13.0738C21.866 13.0115 21.9153 12.9377 21.949 12.8564C21.9827 12.7751 22 12.688 22 12.6C22 12.512 21.9827 12.4249 21.949 12.3436C21.9153 12.2623 21.866 12.1884 21.8038 12.1262C21.7415 12.064 21.6677 12.0147 21.5864 11.981C21.5051 11.9473 21.418 11.93 21.33 11.93ZM11.67 14.93H23.33C23.5077 14.93 23.6781 15.0006 23.8038 15.1262C23.9294 15.2519 24 15.4223 24 15.6C24 15.7777 23.9294 15.9481 23.8038 16.0738C23.6781 16.1994 23.5077 16.27 23.33 16.27H11.67C11.4923 16.27 11.3219 16.1994 11.1962 16.0738C11.0706 15.9481 11 15.7777 11 15.6C11 15.4223 11.0706 15.2519 11.1962 15.1262C11.3219 15.0006 11.4923 14.93 11.67 14.93ZM12.5 20.93C13.3284 20.93 14 20.2584 14 19.43C14 18.6016 13.3284 17.93 12.5 17.93C11.6716 17.93 11 18.6016 11 19.43C11 20.2584 11.6716 20.93 12.5 20.93ZM19 19.43C19 20.2584 18.3284 20.93 17.5 20.93C16.6716 20.93 16 20.2584 16 19.43C16 18.6016 16.6716 17.93 17.5 17.93C18.3284 17.93 19 18.6016 19 19.43Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Featured Image', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postfeaturedimage',
			'id'     => 43,
			'icon'   => '
			<svg viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current">
			<path fill-rule="evenodd" clip-rule="evenodd" d="M7.00003 23V2.42999C7.00003 2.03217 7.15806 1.65064 7.43937 1.36933C7.72067 1.08803 8.1022 0.929993 8.50003 0.929993H26.5C26.8979 0.929993 27.2794 1.08803 27.5607 1.36933C27.842 1.65064 28 2.03217 28 2.42999V24.82C28.0134 25.3536 27.9198 25.8846 27.7247 26.3815C27.5297 26.8784 27.2372 27.3312 26.8644 27.7133C26.4916 28.0954 26.0462 28.399 25.5542 28.6062C25.0623 28.8135 24.5338 28.9202 24 28.92H5.00003C4.46622 28.9202 3.93778 28.8135 3.44584 28.6062C2.9539 28.399 2.50842 28.0954 2.13565 27.7133C1.76288 27.3312 1.47036 26.8784 1.27532 26.3815C1.08029 25.8846 0.986684 25.3536 1.00003 24.82V24H6.00003C6.26525 24 6.5196 23.8946 6.70714 23.7071C6.89467 23.5196 7.00003 23.2652 7.00003 23ZM3.61477 26.8323C4.01691 27.1267 4.50164 27.2869 5.00003 27.29H21C20.5576 26.8178 20.2172 26.2595 20 25.65H2.76003C2.91354 26.1242 3.21262 26.5379 3.61477 26.8323ZM25.4142 25.3442C25.7893 24.9691 26 24.4604 26 23.93V23.53V2.92999H9.00003V22.93C9.00003 23.1952 9.10539 23.4496 9.29292 23.6371C9.48046 23.8246 9.73481 23.93 10 23.93H22C22 24.4604 22.2107 24.9691 22.5858 25.3442C22.9609 25.7193 23.4696 25.93 24 25.93C24.5305 25.93 25.0392 25.7193 25.4142 25.3442ZM23.33 18H11.67C11.4923 18 11.3219 18.0706 11.1962 18.1962C11.0706 18.3219 11 18.4923 11 18.67C11.0026 18.846 11.0744 19.0138 11.1997 19.1373C11.3251 19.2608 11.494 19.33 11.67 19.33H23.33C23.506 19.33 23.6749 19.2608 23.8003 19.1373C23.9256 19.0138 23.9974 18.846 24 18.67C24 18.4923 23.9294 18.3219 23.8038 18.1962C23.6781 18.0706 23.5077 18 23.33 18ZM11.67 20.67H23.33C23.506 20.67 23.6749 20.7392 23.8003 20.8627C23.9256 20.9862 23.9974 21.154 24 21.33C24 21.5077 23.9294 21.6781 23.8038 21.8038C23.6781 21.9294 23.5077 22 23.33 22H11.67C11.4923 22 11.3219 21.9294 11.1962 21.8038C11.0706 21.6781 11 21.5077 11 21.33C11.0026 21.154 11.0744 20.9862 11.1997 20.8627C11.3251 20.7392 11.494 20.67 11.67 20.67ZM11.62 5.16H23.27C23.4636 5.16 23.6493 5.23691 23.7862 5.37382C23.9231 5.51072 24 5.6964 24 5.89V15.46C24 15.6545 23.9234 15.8413 23.7868 15.9798C23.6502 16.1183 23.4645 16.1974 23.27 16.2H11.62C11.4255 16.1974 11.2398 16.1183 11.1032 15.9798C10.9666 15.8413 10.89 15.6545 10.89 15.46V5.89C10.89 5.6964 10.9669 5.51072 11.1038 5.37382C11.2407 5.23691 11.4264 5.16 11.62 5.16ZM22.54 6.63H12.35L12.34 13.28L15.9 8.48L18.9 11.48L22.54 7.8V6.63ZM16.07 10.72L13.07 14.72L22.54 14.75V9.9L18.9 13.58L16.07 10.72Z"/>
			</svg>',
		),

		array(
			'name'   => __( 'Author Box', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postauthorbox',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M27 1H3C2.46957 1 1.96086 1.21071 1.58579 1.58579C1.21071 1.96086 1 2.46957 1 3V27C1 27.5304 1.21071 28.0391 1.58579 28.4142C1.96086 28.7893 2.46957 29 3 29H27C27.5304 29 28.0391 28.7893 28.4142 28.4142C28.7893 28.0391 29 27.5304 29 27V3C29 2.46957 28.7893 1.96086 28.4142 1.58579C28.0391 1.21071 27.5304 1 27 1ZM26.81 26.82H3.19V3.18H26.81V26.82ZM15 17C11.71 17 5.84003 18.75 5.84003 22.25V24.2H24.16V22.21C24.16 18.71 18.29 17 15 17ZM7.59003 22L8.72003 21.08C10.5834 19.842 12.7631 19.1652 15 19.13C17.233 19.1623 19.4108 19.8282 21.28 21.05L22.42 21.97L7.59003 22ZM12.5999 6.56805C13.3104 6.09336 14.1456 5.84 15 5.84C16.1449 5.84264 17.2422 6.29863 18.0518 7.10821C18.8614 7.9178 19.3174 9.01507 19.32 10.16C19.32 11.0144 19.0666 11.8496 18.5919 12.5601C18.1173 13.2705 17.4426 13.8242 16.6532 14.1512C15.8638 14.4781 14.9952 14.5637 14.1572 14.397C13.3192 14.2303 12.5495 13.8189 11.9453 13.2147C11.3411 12.6105 10.9297 11.8408 10.763 11.0028C10.5963 10.1648 10.6819 9.29618 11.0088 8.5068C11.3358 7.71743 11.8895 7.04274 12.5999 6.56805ZM13.8166 11.931C14.1669 12.1651 14.5787 12.29 15 12.29C15.5649 12.29 16.1067 12.0656 16.5061 11.6661C16.9056 11.2667 17.13 10.7249 17.13 10.16C17.13 9.73872 17.0051 9.32691 16.771 8.97663C16.537 8.62635 16.2043 8.35335 15.8151 8.19213C15.4259 8.03092 14.9976 7.98874 14.5845 8.07092C14.1713 8.15311 13.7917 8.35597 13.4939 8.65386C13.196 8.95175 12.9931 9.33127 12.9109 9.74445C12.8287 10.1576 12.8709 10.5859 13.0321 10.9751C13.1933 11.3643 13.4664 11.697 13.8166 11.931Z" />
            </svg>
            ',
		),

		array(
			'name'   => __( 'Post Comments', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postcomments',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path d="M1 3.63999C0.999998 3.29246 1.06861 2.94834 1.20191 2.62739C1.33521 2.30644 1.53056 2.01496 1.77677 1.76968C2.02298 1.5244 2.31519 1.33015 2.63664 1.19807C2.9581 1.06599 3.30247 0.998672 3.65 0.999988H26.36C27.0602 0.999988 27.7317 1.27813 28.2268 1.77323C28.7219 2.26832 29 2.93982 29 3.63999V20.64C29 21.3402 28.7219 22.0117 28.2268 22.5068C27.7317 23.0018 27.0602 23.28 26.36 23.28H6.36L1.85 27.86C1.78011 27.9285 1.69166 27.975 1.59559 27.9937C1.49952 28.0125 1.40008 28.0026 1.30958 27.9653C1.21908 27.928 1.1415 27.865 1.08647 27.7841C1.03144 27.7032 1.00137 27.6079 1 27.51V3.63999ZM3.43 22.83L5.38 20.89H26.57V3.43999H3.43V22.83ZM9.52 17.64V17C9.51949 16.4802 9.67185 15.9718 9.95812 15.5379C10.2444 15.1041 10.6519 14.764 11.13 14.56C12.3503 14.0258 13.6679 13.75 15 13.75C16.3321 13.75 17.6497 14.0258 18.87 14.56C19.3481 14.764 19.7556 15.1041 20.0419 15.5379C20.3282 15.9718 20.4805 16.4802 20.48 17V17.61L9.52 17.64ZM15 12C14.4779 12 13.9674 11.8452 13.5333 11.5551C13.0991 11.265 12.7608 10.8527 12.561 10.3703C12.3611 9.88788 12.3089 9.35706 12.4107 8.84495C12.5126 8.33284 12.764 7.86244 13.1332 7.49323C13.5024 7.12402 13.9729 6.87258 14.485 6.77072C14.9971 6.66885 15.5279 6.72113 16.0103 6.92095C16.4927 7.12076 16.905 7.45914 17.1951 7.89328C17.4852 8.32743 17.64 8.83785 17.64 9.35999C17.64 10.0602 17.3619 10.7317 16.8668 11.2268C16.3717 11.7218 15.7002 12 15 12Z" />
            </svg>
            ',
		),

		array(
			'name'   => __( 'Post Navigation', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postnavigation',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M24.2352 0H4.26372C4.09909 0.00140102 3.93636 0.0352148 3.7848 0.0995105C3.63325 0.163806 3.49584 0.257325 3.38043 0.374726C3.26502 0.492127 3.17387 0.631111 3.11217 0.783742C3.05047 0.936374 3.01945 1.09966 3.02086 1.26429V17.6464C3.01945 17.8111 3.05047 17.9743 3.11217 18.127C3.17387 18.2796 3.26502 18.4186 3.38043 18.536C3.49584 18.6534 3.63325 18.7469 3.7848 18.8112C3.93636 18.8755 4.09909 18.9093 4.26372 18.9107H24.2352C24.3998 18.9093 24.5625 18.8755 24.7141 18.8112C24.8656 18.7469 25.003 18.6534 25.1184 18.536C25.2339 18.4186 25.325 18.2796 25.3867 18.127C25.4484 17.9743 25.4794 17.8111 25.478 17.6464V1.26429C25.4794 1.09966 25.4484 0.936374 25.3867 0.783742C25.325 0.631111 25.2339 0.492127 25.1184 0.374726C25.003 0.257325 24.8656 0.163806 24.7141 0.0995105C24.5625 0.0352148 24.3998 0.00140102 24.2352 0ZM5.51729 2.51786H22.9816V4.52143L16.7459 10.8321L11.6137 5.64643L5.51729 13.8643V2.51786ZM6.74943 16.3929L11.8923 9.48215L16.7459 14.3893L22.9816 8.07858V16.3929H6.74943ZM11.903 25.2107H5.47442L7.91728 22.7464L6.95299 21.7821L3.23514 25.4786C3.17874 25.5326 3.13386 25.5974 3.1032 25.6692C3.07255 25.7411 3.05674 25.8183 3.05674 25.8964C3.05674 25.9745 3.07255 26.0518 3.1032 26.1236C3.13386 26.1954 3.17874 26.2603 3.23514 26.3143L6.92085 30L7.88514 29.0357L5.44228 26.5714H11.8709L11.903 25.2107ZM23.0565 26.5714H16.6279L16.703 25.2107H23.1315L20.678 22.7464L21.6422 21.7821L25.3387 25.4786C25.4473 25.5905 25.5081 25.7404 25.5081 25.8964C25.5081 26.0524 25.4473 26.2023 25.3387 26.3143L21.6422 30L20.678 29.0357L23.0565 26.5714Z" />
            </svg>
            
            ',
		),

		array(
			'name'   => __( 'Post Info', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'postinfo',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.50003 23.08V2.49998C7.50003 2.10216 7.65806 1.72063 7.93937 1.43932C8.22067 1.15802 8.60221 0.999984 9.00003 0.999984H27C27.2004 0.99464 27.3997 1.02949 27.5863 1.10248C27.773 1.17546 27.9431 1.2851 28.0866 1.42493C28.2302 1.56475 28.3443 1.73192 28.4221 1.91657C28.5 2.10121 28.5401 2.29959 28.54 2.49998V24.9C28.5534 25.4336 28.4598 25.9645 28.2647 26.4614C28.0697 26.9584 27.7772 27.4112 27.4044 27.7933C27.0316 28.1754 26.5862 28.479 26.0942 28.6862C25.6023 28.8935 25.0738 29.0002 24.54 29H5.50003C4.96622 29.0002 4.43778 28.8935 3.94584 28.6862C3.4539 28.479 3.00842 28.1754 2.63565 27.7933C2.26288 27.4112 1.97036 26.9584 1.77532 26.4614C1.58029 25.9645 1.48668 25.4336 1.50003 24.9V24.08H6.50003C6.76525 24.08 7.0196 23.9746 7.20714 23.7871C7.39467 23.5996 7.50003 23.3452 7.50003 23.08ZM4.11614 26.9004C4.51799 27.1946 5.00201 27.3554 5.50003 27.36H21.5C21.0596 26.8863 20.7195 26.3284 20.5 25.72H3.26003C3.41486 26.1933 3.71429 26.6062 4.11614 26.9004ZM25.9142 25.4142C26.2893 25.0391 26.5 24.5304 26.5 24V23.59V2.99998H9.50003V23C9.50003 23.2652 9.60539 23.5196 9.79292 23.7071C9.98046 23.8946 10.2348 24 10.5 24H22.5C22.5 24.5304 22.7107 25.0391 23.0858 25.4142C23.4609 25.7893 23.9696 26 24.5 26C25.0305 26 25.5392 25.7893 25.9142 25.4142ZM14 10.5C14 11.3284 13.3284 12 12.5 12C11.6716 12 11 11.3284 11 10.5C11 9.67156 11.6716 8.99998 12.5 8.99998C13.3284 8.99998 14 9.67156 14 10.5ZM18 12C18.8284 12 19.5 11.3284 19.5 10.5C19.5 9.67156 18.8284 8.99998 18 8.99998C17.1716 8.99998 16.5 9.67156 16.5 10.5C16.5 11.3284 17.1716 12 18 12ZM25 10.5C25 11.3284 24.3284 12 23.5 12C22.6716 12 22 11.3284 22 10.5C22 9.67156 22.6716 8.99998 23.5 8.99998C24.3284 8.99998 25 9.67156 25 10.5ZM11.67 5.99998H22.33C22.418 5.99998 22.5051 6.01731 22.5864 6.05099C22.6677 6.08466 22.7415 6.13401 22.8038 6.19622C22.866 6.25844 22.9153 6.3323 22.949 6.41359C22.9827 6.49487 23 6.582 23 6.66998C22.9974 6.84594 22.9256 7.0138 22.8003 7.13729C22.6749 7.26079 22.506 7.33 22.33 7.32998H11.67C11.494 7.33 11.3251 7.26079 11.1997 7.13729C11.0744 7.0138 11.0026 6.84594 11 6.66998C11 6.49229 11.0706 6.32187 11.1962 6.19622C11.3219 6.07057 11.4923 5.99998 11.67 5.99998ZM24.8038 14.1962C24.6781 14.0706 24.5077 14 24.33 14H11.67C11.4923 14 11.3219 14.0706 11.1962 14.1962C11.0706 14.3219 11 14.4923 11 14.67C11.0026 14.8459 11.0744 15.0138 11.1997 15.1373C11.3251 15.2608 11.494 15.33 11.67 15.33H24.33C24.506 15.33 24.6749 15.2608 24.8003 15.1373C24.9256 15.0138 24.9974 14.8459 25 14.67C25 14.4923 24.9294 14.3219 24.8038 14.1962ZM11.67 17H22.33C22.418 17 22.5051 17.0173 22.5864 17.051C22.6677 17.0847 22.7415 17.134 22.8038 17.1962C22.866 17.2584 22.9153 17.3323 22.949 17.4136C22.9827 17.4949 23 17.582 23 17.67C22.9974 17.8459 22.9256 18.0138 22.8003 18.1373C22.6749 18.2608 22.506 18.33 22.33 18.33H11.67C11.494 18.33 11.3251 18.2608 11.1997 18.1373C11.0744 18.0138 11.0026 17.8459 11 17.67C11 17.4923 11.0706 17.3219 11.1962 17.1962C11.3219 17.0706 11.4923 17 11.67 17ZM18.33 20H11.67C11.4923 20 11.3219 20.0706 11.1962 20.1962C11.0706 20.3219 11 20.4923 11 20.67C11.0026 20.8459 11.0744 21.0138 11.1997 21.1373C11.3251 21.2608 11.494 21.33 11.67 21.33H18.33C18.506 21.33 18.6749 21.2608 18.8003 21.1373C18.9256 21.0138 18.9974 20.8459 19 20.67C19 20.582 18.9827 20.4949 18.949 20.4136C18.9153 20.3323 18.866 20.2584 18.8038 20.1962C18.7415 20.134 18.6677 20.0847 18.5864 20.051C18.5051 20.0173 18.418 20 18.33 20Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Archive Title', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'archivetitle',
			'id'     => 43,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 2.5V27.5C1 27.8978 1.15804 28.2794 1.43934 28.5607C1.72064 28.842 2.10218 29 2.5 29H27.5C27.8978 29 28.2794 28.842 28.5607 28.5607C28.842 28.2794 29 27.8978 29 27.5V2.5C29 2.10218 28.842 1.72064 28.5607 1.43934C28.2794 1.15804 27.8978 1 27.5 1H2.5C2.10218 1 1.72064 1.15804 1.43934 1.43934C1.15804 1.72064 1 2.10218 1 2.5ZM27 27H3V8H27V27ZM27 6V3H3V6H27ZM12.89 19V18.47C13.2 18.4844 13.5104 18.4507 13.81 18.37C13.8594 18.3428 13.9027 18.3056 13.9371 18.2609C13.9716 18.2161 13.9964 18.1648 14.01 18.11C14.0733 17.5591 14.0967 17.0043 14.08 16.45V12.59V10.83H13.16H11.93C11.79 10.83 11.71 10.83 11.68 10.89C11.65 10.95 11.63 10.99 11.61 11.11C11.549 11.44 11.5156 11.7745 11.51 12.11H11V10.63C11 10.52 11 10.23 10.94 10.01L11 9.95L11.64 10H18.56L19.16 9.95L19.22 10.01C19.22 10.1716 19.1985 10.3189 19.1791 10.4518L19.1791 10.4518C19.1661 10.541 19.154 10.6237 19.15 10.7V12.11H18.61C18.61 11.78 18.61 11.46 18.53 11.11C18.52 11.0145 18.4893 10.9224 18.44 10.84H18.24C18.0748 10.84 17.8969 10.8295 17.7044 10.8181L17.7044 10.8181C17.4775 10.8046 17.2305 10.79 16.96 10.79H16.04V12.55V16.41C15.9854 16.9783 15.972 17.5498 16 18.12C16.0149 18.173 16.0402 18.2224 16.0746 18.2653C16.109 18.3083 16.1516 18.3439 16.2 18.37C16.4997 18.4507 16.81 18.4844 17.12 18.47V19C16.6661 19 16.2481 18.9821 15.8693 18.9658H15.8693H15.8693H15.8692C15.5553 18.9523 15.2683 18.94 15.01 18.94C14.7491 18.94 14.4505 18.9526 14.1266 18.9662C13.7429 18.9824 13.3238 19 12.89 19ZM16.67 21H24.33C24.418 21 24.5051 21.0173 24.5864 21.051C24.6677 21.0847 24.7415 21.134 24.8038 21.1962C24.866 21.2585 24.9153 21.3323 24.949 21.4136C24.9827 21.4949 25 21.582 25 21.67C24.9974 21.846 24.9256 22.0138 24.8003 22.1373C24.6749 22.2608 24.506 22.33 24.33 22.33H16.67C16.494 22.33 16.3251 22.2608 16.1997 22.1373C16.0744 22.0138 16.0026 21.846 16 21.67C16 21.582 16.0173 21.4949 16.051 21.4136C16.0847 21.3323 16.134 21.2585 16.1962 21.1962C16.2585 21.134 16.3323 21.0847 16.4136 21.051C16.4949 21.0173 16.582 21 16.67 21ZM24.33 23.67H16.67C16.494 23.67 16.3251 23.7392 16.1997 23.8627C16.0744 23.9862 16.0026 24.154 16 24.33C16 24.418 16.0173 24.5051 16.051 24.5864C16.0847 24.6677 16.134 24.7415 16.1962 24.8038C16.2585 24.866 16.3323 24.9153 16.4136 24.949C16.4949 24.9827 16.582 25 16.67 25H24.33C24.5077 25 24.6781 24.9294 24.8038 24.8038C24.9294 24.6781 25 24.5077 25 24.33C24.9974 24.154 24.9256 23.9862 24.8003 23.8627C24.6749 23.7392 24.506 23.67 24.33 23.67ZM5.67 21H13.33C13.418 21 13.5051 21.0173 13.5864 21.051C13.6677 21.0847 13.7415 21.134 13.8038 21.1962C13.866 21.2585 13.9153 21.3323 13.949 21.4136C13.9827 21.4949 14 21.582 14 21.67C13.9974 21.846 13.9256 22.0138 13.8003 22.1373C13.6749 22.2608 13.506 22.33 13.33 22.33H5.67C5.49402 22.33 5.32511 22.2608 5.19974 22.1373C5.07437 22.0138 5.00263 21.846 5 21.67C5 21.582 5.01733 21.4949 5.051 21.4136C5.08467 21.3323 5.13402 21.2585 5.19624 21.1962C5.25845 21.134 5.33231 21.0847 5.4136 21.051C5.49489 21.0173 5.58201 21 5.67 21ZM13.33 23.67H5.67C5.49402 23.67 5.32511 23.7392 5.19974 23.8627C5.07437 23.9862 5.00263 24.154 5 24.33C5 24.5077 5.07059 24.6781 5.19624 24.8038C5.32189 24.9294 5.4923 25 5.67 25H13.33C13.5077 25 13.6781 24.9294 13.8038 24.8038C13.9294 24.6781 14 24.5077 14 24.33C13.9974 24.154 13.9256 23.9862 13.8003 23.8627C13.6749 23.7392 13.506 23.67 13.33 23.67Z" />
</svg>
',
		),

		// array(
		//     'name'   => __('Template Tags', 'coming-soon'),
		//     'is_pro' => true,
		//     'cat'    => 'templatetag',
		//     'type'   => 'templatetag',
		//     'id'     => 43,
		//     'icon'   => '
		// 	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="sp-w-6 sp-fill-current"><path d="M256 8C119.3 8 8 119.2 8 256c0 136.7 111.3 248 248 248s248-111.3 248-248C504 119.2 392.7 8 256 8zM33 256c0-32.3 6.9-63 19.3-90.7l106.4 291.4C84.3 420.5 33 344.2 33 256zm223 223c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2L200.6 393l-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3C109.6 73 178.1 33 256 33c58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"/></svg>',
		// ),

		array(
			'name'   => __( 'Site Logo', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'sitelogo',
			'id'     => 81,
			'icon'   => '
            <svg  viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg" class="sp-w-6 sp-fill-current">
            <path fill-rule="evenodd" clip-rule="evenodd" d="M3.33 1.75999H26.67C27.106 1.75868 27.538 1.84325 27.9413 2.00888C28.3446 2.17452 28.7113 2.41796 29.0205 2.72532C29.3297 3.03269 29.5754 3.39794 29.7435 3.80024C29.9115 4.20254 29.9987 4.63401 30 5.06999V24.93C29.9947 25.8097 29.6415 26.6516 29.0176 27.2717C28.3937 27.8919 27.5497 28.24 26.67 28.24H3.33C2.89401 28.2413 2.46203 28.1567 2.05873 27.9911C1.65542 27.8255 1.28869 27.582 0.979472 27.2747C0.670253 26.9673 0.424601 26.602 0.256543 26.1997C0.0884846 25.7974 0.00131124 25.366 0 24.93V5.06999C0.00131124 4.63401 0.0884846 4.20254 0.256543 3.80024C0.424601 3.39794 0.670253 3.03269 0.979472 2.72532C1.28869 2.41796 1.65542 2.17452 2.05873 2.00888C2.46203 1.84325 2.89401 1.75868 3.33 1.75999ZM2.94 25.29H27.06V8.37999H2.94V25.29ZM5.88 4.70999H3.53C3.37524 4.70996 3.22667 4.77075 3.11631 4.87924C3.00594 4.98774 2.94263 5.13525 2.94 5.28999C2.94 5.44646 3.00216 5.59653 3.11281 5.70718C3.22346 5.81783 3.37352 5.87999 3.53 5.87999H5.88C5.95786 5.88134 6.03518 5.867 6.10738 5.83783C6.17957 5.80866 6.24515 5.76525 6.30021 5.7102C6.35527 5.65514 6.39868 5.58956 6.42785 5.51736C6.45702 5.44517 6.47136 5.36784 6.47 5.28999C6.47001 5.21297 6.45469 5.13672 6.42492 5.0657C6.39514 4.99467 6.35153 4.93028 6.2966 4.87629C6.24168 4.8223 6.17656 4.77979 6.10503 4.75123C6.0335 4.72268 5.95701 4.70866 5.88 4.70999ZM18.23 4.70999H15.88C15.7252 4.70996 15.5767 4.77075 15.4663 4.87924C15.3559 4.98774 15.2926 5.13525 15.29 5.28999C15.29 5.44646 15.3522 5.59653 15.4628 5.70718C15.5735 5.81783 15.7235 5.87999 15.88 5.87999H18.23C18.3079 5.88134 18.3852 5.867 18.4574 5.83783C18.5296 5.80866 18.5952 5.76525 18.6502 5.7102C18.7053 5.65514 18.7487 5.58956 18.7778 5.51736C18.807 5.44517 18.8214 5.36784 18.82 5.28999C18.82 5.21297 18.8047 5.13672 18.7749 5.0657C18.7451 4.99467 18.7015 4.93028 18.6466 4.87629C18.5917 4.8223 18.5266 4.77979 18.455 4.75123C18.3835 4.72268 18.307 4.70866 18.23 4.70999ZM20 4.70999H22.35C22.427 4.70866 22.5035 4.72268 22.575 4.75123C22.6466 4.77979 22.7117 4.8223 22.7666 4.87629C22.8215 4.93028 22.8651 4.99467 22.8949 5.0657C22.9247 5.13672 22.94 5.21297 22.94 5.28999C22.9414 5.36784 22.927 5.44517 22.8979 5.51736C22.8687 5.58956 22.8253 5.65514 22.7702 5.7102C22.7152 5.76525 22.6496 5.80866 22.5774 5.83783C22.5052 5.867 22.4279 5.88134 22.35 5.87999H20C19.8435 5.87999 19.6935 5.81783 19.5828 5.70718C19.4722 5.59653 19.41 5.44646 19.41 5.28999C19.4126 5.13525 19.4759 4.98774 19.5863 4.87924C19.6967 4.77075 19.8452 4.70996 20 4.70999ZM26.47 4.70999H24.12C24.043 4.70866 23.9665 4.72268 23.895 4.75123C23.8234 4.77979 23.7583 4.8223 23.7034 4.87629C23.6485 4.93028 23.6049 4.99467 23.5751 5.0657C23.5453 5.13672 23.53 5.21297 23.53 5.28999C23.5286 5.36784 23.543 5.44517 23.5722 5.51736C23.6013 5.58956 23.6447 5.65514 23.6998 5.7102C23.7549 5.76525 23.8204 5.80866 23.8926 5.83783C23.9648 5.867 24.0422 5.88134 24.12 5.87999H26.47C26.6265 5.87999 26.7765 5.81783 26.8872 5.70718C26.9978 5.59653 27.06 5.44646 27.06 5.28999C27.0574 5.13525 26.9941 4.98774 26.8837 4.87924C26.7733 4.77075 26.6248 4.70996 26.47 4.70999ZM24.33 12.67H17.67C17.494 12.67 17.3251 12.7392 17.1997 12.8627C17.0744 12.9862 17.0026 13.1541 17 13.33C17 13.418 17.0173 13.5051 17.051 13.5864C17.0847 13.6677 17.134 13.7416 17.1962 13.8038C17.2585 13.866 17.3323 13.9153 17.4136 13.949C17.4949 13.9827 17.582 14 17.67 14H24.33C24.5077 14 24.6781 13.9294 24.8038 13.8038C24.9294 13.6781 25 13.5077 25 13.33C24.9974 13.1541 24.9256 12.9862 24.8003 12.8627C24.6749 12.7392 24.506 12.67 24.33 12.67ZM17.67 19H24.33C24.5077 19 24.6781 19.0706 24.8038 19.1962C24.9294 19.3219 25 19.4923 25 19.67C24.9974 19.846 24.9256 20.0138 24.8003 20.1373C24.6749 20.2608 24.506 20.33 24.33 20.33H17.67C17.494 20.33 17.3251 20.2608 17.1997 20.1373C17.0744 20.0138 17.0026 19.846 17 19.67C17 19.582 17.0173 19.4949 17.051 19.4136C17.0847 19.3323 17.134 19.2585 17.1962 19.1962C17.2585 19.134 17.3323 19.0847 17.4136 19.051C17.4949 19.0173 17.582 19 17.67 19ZM24.33 15.67H17.67C17.494 15.67 17.3251 15.7392 17.1997 15.8627C17.0744 15.9862 17.0026 16.1541 17 16.33C17 16.418 17.0173 16.5051 17.051 16.5864C17.0847 16.6677 17.134 16.7416 17.1962 16.8038C17.2585 16.866 17.3323 16.9153 17.4136 16.949C17.4949 16.9827 17.582 17 17.67 17H24.33C24.5077 17 24.6781 16.9294 24.8038 16.8038C24.9294 16.6781 25 16.5077 25 16.33C24.9974 16.1541 24.9256 15.9862 24.8003 15.8627C24.6749 15.7392 24.506 15.67 24.33 15.67ZM5 22V21.39C4.99966 20.8677 5.1531 20.3568 5.44119 19.9211C5.72928 19.4854 6.13926 19.1442 6.62 18.94C7.84381 18.4059 9.16471 18.1302 10.5 18.1302C11.8353 18.1302 13.1562 18.4059 14.38 18.94C14.8592 19.1463 15.2677 19.4881 15.5555 19.9233C15.8433 20.3585 15.9978 20.8682 16 21.39V22H5ZM9.02772 15.8534C9.46351 16.1446 9.97586 16.3 10.5 16.3C11.2028 16.3 11.8768 16.0208 12.3738 15.5238C12.8708 15.0269 13.15 14.3528 13.15 13.65C13.15 13.1259 12.9946 12.6135 12.7034 12.1777C12.4122 11.742 11.9983 11.4023 11.5141 11.2017C11.0299 11.0011 10.497 10.9487 9.98299 11.0509C9.46894 11.1532 8.99675 11.4056 8.62614 11.7762C8.25554 12.1468 8.00315 12.619 7.9009 13.133C7.79865 13.6471 7.85112 14.1799 8.0517 14.6641C8.25227 15.1483 8.59192 15.5622 9.02772 15.8534Z" />
</svg>
',
		),

		array(
			'name'   => __( 'Template Parts', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'templatetag',
			'type'   => 'seedprodtemplateparts',
			'id'     => 47,
			'icon'   => '
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 2.5V27.5C1 27.8978 1.15804 28.2794 1.43934 28.5607C1.72064 28.842 2.10218 29 2.5 29H27.5C27.8978 29 28.2794 28.842 28.5607 28.5607C28.842 28.2794 29 27.8978 29 27.5V2.5C29 2.10218 28.842 1.72064 28.5607 1.43934C28.2794 1.15804 27.8978 1 27.5 1H2.5C2.10218 1 1.72064 1.15804 1.43934 1.43934C1.15804 1.72064 1 2.10218 1 2.5ZM27 27H3V3H27V27ZM23.5 6.5V9.5H6.5V6.5H23.5ZM24 5H6C5.73478 5 5.48043 5.10536 5.29289 5.29289C5.10536 5.48043 5 5.73478 5 6V10C5 10.2652 5.10536 10.5196 5.29289 10.7071C5.48043 10.8946 5.73478 11 6 11H24C24.2652 11 24.5196 10.8946 24.7071 10.7071C24.8946 10.5196 25 10.2652 25 10V6C25 5.73478 24.8946 5.48043 24.7071 5.29289C24.5196 5.10536 24.2652 5 24 5ZM14.86 14.66C9.89997 14 9.65997 14 9.65997 14C9.65997 14 9.83997 15.66 10.27 19.23C10.4311 20.7189 11.1157 22.1021 12.2018 23.1332C13.2878 24.1643 14.7048 24.7763 16.2 24.86L17.25 24.91C17.25 24.91 17.35 21.09 16.37 19.29C15.39 17.49 12.81 17.18 12.81 17.18C13.568 17.7485 14.2414 18.4219 14.81 19.18C15.7 20.37 15.6 23.09 15.6 23.09C14.6622 22.8322 13.816 22.3156 13.1582 21.5994C12.5003 20.8832 12.0573 19.9962 11.88 19.04C11.56 16.72 11.5 15.86 11.5 15.86C11.5 15.86 11.2 15.8 14.65 16.26C18.1 16.72 18.96 20.8 18.49 24.72C21.53 20.34 19.82 15.32 14.86 14.66Z" />
            </svg>
            ',
		),

	);

	global $wp_widget_factory;
	$all_widgets = $wp_widget_factory->widgets;
	//print_r($all_widgets);

	$wordpress_widgets = array();

	$random_id = 300;
	foreach ( $all_widgets as $k => $value ) {
		if ( 'WP_Widget_Custom_HTML' != $k ) {
			$random_id       = $random_id + 10;
			$block_options[] = array(
				'name'    => $value->name,
				'is_pro'  => true,
				'cat'     => 'wpw',
				'type'    => 'wpwidgetblock-' . $k,
				'base_id' => $value->id_base,
				'id'      => $random_id,
				'icon'    => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" class="sp-w-6 sp-fill-current"><path d="M256 8C119.3 8 8 119.2 8 256c0 136.7 111.3 248 248 248s248-111.3 248-248C504 119.2 392.7 8 256 8zM33 256c0-32.3 6.9-63 19.3-90.7l106.4 291.4C84.3 420.5 33 344.2 33 256zm223 223c-21.9 0-43-3.2-63-9.1l66.9-194.4 68.5 187.8c.5 1.1 1 2.1 1.6 3.1-23.1 8.1-48 12.6-74 12.6zm30.7-327.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-21.9 0-58.7-2.8-58.7-2.8-12-.7-13.4 17.7-1.4 18.4 0 0 11.4 1.4 23.4 2.1l34.7 95.2L200.6 393l-81.2-241.5c13.4-.7 25.5-2.1 25.5-2.1 12-1.4 10.6-19.1-1.4-18.4 0 0-36.1 2.8-59.4 2.8-4.2 0-9.1-.1-14.4-.3C109.6 73 178.1 33 256 33c58 0 110.9 22.2 150.6 58.5-1-.1-1.9-.2-2.9-.2-21.9 0-37.4 19.1-37.4 39.6 0 18.4 10.6 33.9 21.9 52.3 8.5 14.8 18.4 33.9 18.4 61.5 0 19.1-7.3 41.2-17 72.1l-22.2 74.3-80.7-239.6zm81.4 297.2l68.1-196.9c12.7-31.8 17-57.2 17-79.9 0-8.2-.5-15.8-1.5-22.9 17.4 31.8 27.3 68.2 27.3 107 0 82.3-44.6 154.1-110.9 192.7z"/></svg>',
			);
		}
	}

	//print_r($wordpress_widgets);
	// filter out some options
	$theme_enabled = get_option( 'seedprod_theme_enabled' );
	$theme_builder = seedprod_lite_cu( 'themebuilder' );

	if ( ! empty( $theme_builder ) && ! empty( $theme_enabled ) ) {
		$block_options[] = array(
			'name'   => __( 'Template Parts', 'coming-soon' ),
			'is_pro' => true,
			'cat'    => 'adv',
			'type'   => 'seedprodtemplateparts',
			'id'     => 47,
			'icon'   => '
			   <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 30 30" class="sp-w-6 sp-fill-current"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 2.5V27.5C1 27.8978 1.15804 28.2794 1.43934 28.5607C1.72064 28.842 2.10218 29 2.5 29H27.5C27.8978 29 28.2794 28.842 28.5607 28.5607C28.842 28.2794 29 27.8978 29 27.5V2.5C29 2.10218 28.842 1.72064 28.5607 1.43934C28.2794 1.15804 27.8978 1 27.5 1H2.5C2.10218 1 1.72064 1.15804 1.43934 1.43934C1.15804 1.72064 1 2.10218 1 2.5ZM27 27H3V3H27V27ZM23.5 6.5V9.5H6.5V6.5H23.5ZM24 5H6C5.73478 5 5.48043 5.10536 5.29289 5.29289C5.10536 5.48043 5 5.73478 5 6V10C5 10.2652 5.10536 10.5196 5.29289 10.7071C5.48043 10.8946 5.73478 11 6 11H24C24.2652 11 24.5196 10.8946 24.7071 10.7071C24.8946 10.5196 25 10.2652 25 10V6C25 5.73478 24.8946 5.48043 24.7071 5.29289C24.5196 5.10536 24.2652 5 24 5ZM14.86 14.66C9.89997 14 9.65997 14 9.65997 14C9.65997 14 9.83997 15.66 10.27 19.23C10.4311 20.7189 11.1157 22.1021 12.2018 23.1332C13.2878 24.1643 14.7048 24.7763 16.2 24.86L17.25 24.91C17.25 24.91 17.35 21.09 16.37 19.29C15.39 17.49 12.81 17.18 12.81 17.18C13.568 17.7485 14.2414 18.4219 14.81 19.18C15.7 20.37 15.6 23.09 15.6 23.09C14.6622 22.8322 13.816 22.3156 13.1582 21.5994C12.5003 20.8832 12.0573 19.9962 11.88 19.04C11.56 16.72 11.5 15.86 11.5 15.86C11.5 15.86 11.2 15.8 14.65 16.26C18.1 16.72 18.96 20.8 18.49 24.72C21.53 20.34 19.82 15.32 14.86 14.66Z" />
			   </svg>
			   ',
		);
	}

	return $block_options;
}


/**
* Get times
*/
function seedprod_lite_get_default_timezone() {
	$general_settings = get_option( 'seedprod_settings' );
	$timezone         = 'UTC';

	if ( ! empty( $general_settings ) ) {
		$general_settings = json_decode( $general_settings );
		if ( ! empty( $general_settings->default_timezone ) ) {
			$timezone = $general_settings->default_timezone;
		}
	}

	return $timezone;
}



/**
* Get times
*/
function seedprod_lite_get_times() {
	$times   = array();
	$times[] = array(
		'v' => '',
		'l' => __( 'Select Time', 'coming-soon' ),
	);
	$times[] = array(
		'v' => '00:00',
		'l' => '12:00 A.M.',
	);
	$times[] = array(
		'v' => '00:30',
		'l' => '12:30 A.M.',
	);
	$times[] = array(
		'v' => '01:00',
		'l' => '1:00 A.M.',
	);
	$times[] = array(
		'v' => '01:30',
		'l' => '1:30 A.M.',
	);
	$times[] = array(
		'v' => '02:00',
		'l' => '2:00 A.M.',
	);
	$times[] = array(
		'v' => '02:30',
		'l' => '2:30 A.M.',
	);
	$times[] = array(
		'v' => '03:00',
		'l' => '3:00 A.M.',
	);
	$times[] = array(
		'v' => '03:30',
		'l' => '3:30 A.M.',
	);
	$times[] = array(
		'v' => '04:00',
		'l' => '4:00 A.M.',
	);
	$times[] = array(
		'v' => '04:30',
		'l' => '4:30 A.M.',
	);
	$times[] = array(
		'v' => '05:00',
		'l' => '5:00 A.M.',
	);
	$times[] = array(
		'v' => '05:30',
		'l' => '5:30 A.M.',
	);
	$times[] = array(
		'v' => '06:00',
		'l' => '6:00 A.M.',
	);
	$times[] = array(
		'v' => '06:30',
		'l' => '6:30 A.M.',
	);
	$times[] = array(
		'v' => '07:00',
		'l' => '7:00 A.M.',
	);
	$times[] = array(
		'v' => '07:30',
		'l' => '7:30 A.M.',
	);
	$times[] = array(
		'v' => '08:00',
		'l' => '8:00 A.M.',
	);
	$times[] = array(
		'v' => '08:30',
		'l' => '8:30 A.M.',
	);
	$times[] = array(
		'v' => '09:00',
		'l' => '9:00 A.M.',
	);
	$times[] = array(
		'v' => '09:30',
		'l' => '9:30 A.M.',
	);
	$times[] = array(
		'v' => '10:00',
		'l' => '10:00 A.M.',
	);
	$times[] = array(
		'v' => '10:30',
		'l' => '10:30 A.M.',
	);
	$times[] = array(
		'v' => '11:00',
		'l' => '11:00 A.M.',
	);
	$times[] = array(
		'v' => '11:30',
		'l' => '11:30 A.M.',
	);
	$times[] = array(
		'v' => '12:00',
		'l' => '12:00 P.M.',
	);
	$times[] = array(
		'v' => '12:30',
		'l' => '12:30 P.M.',
	);
	$times[] = array(
		'v' => '13:00',
		'l' => '1:00 P.M.',
	);
	$times[] = array(
		'v' => '13:30',
		'l' => '1:30 P.M.',
	);
	$times[] = array(
		'v' => '14:00',
		'l' => '2:00 P.M.',
	);
	$times[] = array(
		'v' => '14:30',
		'l' => '2:30 P.M.',
	);
	$times[] = array(
		'v' => '15:00',
		'l' => '3:00 P.M.',
	);
	$times[] = array(
		'v' => '15:30',
		'l' => '3:30 P.M.',
	);
	$times[] = array(
		'v' => '16:00',
		'l' => '4:00 P.M.',
	);
	$times[] = array(
		'v' => '16:30',
		'l' => '4:30 P.M.',
	);
	$times[] = array(
		'v' => '17:00',
		'l' => '5:00 P.M.',
	);
	$times[] = array(
		'v' => '17:30',
		'l' => '5:30 P.M.',
	);
	$times[] = array(
		'v' => '18:00',
		'l' => '6:00 P.M.',
	);
	$times[] = array(
		'v' => '18:30',
		'l' => '6:30 P.M.',
	);
	$times[] = array(
		'v' => '19:00',
		'l' => '7:00 P.M.',
	);
	$times[] = array(
		'v' => '19:30',
		'l' => '7:30 P.M.',
	);
	$times[] = array(
		'v' => '20:00',
		'l' => '8:00 P.M.',
	);
	$times[] = array(
		'v' => '20:30',
		'l' => '8:30 P.M.',
	);
	$times[] = array(
		'v' => '21:00',
		'l' => '9:00 P.M.',
	);
	$times[] = array(
		'v' => '21:30',
		'l' => '9:30 P.M.',
	);
	$times[] = array(
		'v' => '22:00',
		'l' => '10:00 P.M.',
	);
	$times[] = array(
		'v' => '22:30',
		'l' => '10:30 P.M.',
	);
	$times[] = array(
		'v' => '23:00',
		'l' => '11:00 P.M.',
	);
	$times[] = array(
		'v' => '23:30',
		'l' => '11:30 P.M.',
	);

	return $times;
}

/**
* Check per
*/
function seedprod_lite_get_api_key() {
	$seedprod_api_key = '';

	if ( defined( 'SEEDPROD_API_KEY' ) ) {
		$seedprod_api_key = SEEDPROD_API_KEY;
	}

	if ( empty( $seedprod_api_key ) ) {
		$seedprod_api_key = get_option( 'seedprod_api_key ' );
	}

	return $seedprod_api_key;
}

/**
* Get timezones
*/
function seedprod_lite_get_timezones() {
	// timezones
	$zonen      = array();
	$continents = array( 'Africa', 'America', 'Antarctica', 'Arctic', 'Asia', 'Atlantic', 'Australia', 'Europe', 'Indian', 'Pacific' );

	foreach ( timezone_identifiers_list() as $zone ) {
		$zone = explode( '/', $zone );
		if ( ! in_array( $zone[0], $continents ) ) {
			continue;
		}

		// This determines what gets set and translated - we don't translate Etc/* strings here, they are done later
		$exists    = array(
			0 => ( isset( $zone[0] ) && $zone[0] ),
			1 => ( isset( $zone[1] ) && $zone[1] ),
			2 => ( isset( $zone[2] ) && $zone[2] ),
		);
		$exists[3] = ( $exists[0] && 'Etc' !== $zone[0] );
		$exists[4] = ( $exists[1] && $exists[3] );
		$exists[5] = ( $exists[2] && $exists[3] );

		$zonen[] = array(
			'continent'   => ( $exists[0] ? $zone[0] : '' ),
			'city'        => ( $exists[1] ? $zone[1] : '' ),
			'subcity'     => ( $exists[2] ? $zone[2] : '' ),
			't_continent' => ( $exists[3] ? __( str_replace( '_', ' ', $zone[0] ), 'continents-cities' ) : '' ), // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
			't_city'      => ( $exists[4] ? __( str_replace( '_', ' ', $zone[1] ), 'continents-cities' ) : '' ), // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
			't_subcity'   => ( $exists[5] ? __( str_replace( '_', ' ', $zone[2] ), 'continents-cities' ) : '' ), // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
		);
	}
	usort( $zonen, '_wp_timezone_choice_usort_callback' );

	$structure = array();

	foreach ( $zonen as $key => $zone ) {
		// Build value in an array to join later
		$value = array( $zone['continent'] );

		if ( empty( $zone['city'] ) ) {
			// It's at the continent level (generally won't happen)
			$display = $zone['t_continent'];
		} else {
			// It's inside a continent group

			// Continent optgroup
			if ( ! isset( $zonen[ $key - 1 ] ) || $zonen[ $key - 1 ]['continent'] !== $zone['continent'] ) {
				$label = $zone['t_continent'];
				//$structure[] = $label ;
			}

			// Add the city to the value
			$value[] = $zone['city'];

			// get offset
			// $timezone = $label.'/'.str_replace(' ', '_', $zone['t_city']);
			// $time = new \DateTime('now', new DateTimeZone($timezone));
			// $timezone_offset = $time->format('P');

			$display = $zone['t_city'];
			if ( ! empty( $zone['subcity'] ) ) {
				// Add the subcity to the value
				$value[]  = $zone['subcity'];
				$display .= ' - ' . $zone['t_subcity'];
			}
		}

		// Build the value
		$value = join( '/', $value );

		// get offset
		$time                  = new \DateTime( 'now', new DateTimeZone( $value ) );
		$timezone_offset       = $time->format( 'P' );
		$structure[ $label ][] = array(
			'v' => $value,
			'l' => $display . ' (' . $timezone_offset . ' GMT)',
		);
	}

	$structure['UTC'][] = array(
		'v' => 'UTC',
		'l' => 'UTC',
	);

	return $structure;
}

/**
* Add to array if value does not exist
*/
function seedprod_lite_array_add( $arr, $key, $value ) {
	if ( ! array_key_exists( $key, $arr ) ) {
		$arr[ $key ] = $value;
	}
	return $arr;
}

/**
* Check per
*/
function seedprod_lite_cu( $rper = null ) {
	if ( ! empty( $rper ) ) {
		$uper = explode( ',', get_option( 'seedprod_per' ) );
		if ( in_array( $rper, $uper ) ) {
			return true;
		} else {
			return false;
		}
	} else {
		$a = get_option( 'seedprod_a' );
		if ( $a ) {
			return true;
		} else {
			return false;
		}
	}
}

/**
 * Upgrade link.
 *
 * @param string $medium Medium.
 * @return string SeedProd Upgrade Link.
 */
function seedprod_lite_upgrade_link( $medium = 'link' ) {
	return apply_filters( 'seedprod_lite_upgrade_link', 'https://seedprod.com/lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=' . sanitize_key( apply_filters( 'seedprod_lite_upgrade_link_medium', $medium ) ) );
}

/**
 * Disable admin notices.
 *
 * @return void
 */
function seedprod_lite_disable_admin_notices() {
	global $wp_filter;
	if ( is_user_admin() ) {
		if ( isset( $wp_filter['user_admin_notices'] ) ) {
			unset( $wp_filter['user_admin_notices'] );
		}
	} elseif ( isset( $wp_filter['admin_notices'] ) ) {
		unset( $wp_filter['admin_notices'] );
	}
	if ( isset( $wp_filter['all_admin_notices'] ) ) {
		unset( $wp_filter['all_admin_notices'] );
	}
}

$get_page = ! empty( $_GET['page'] ) ? sanitize_text_field( wp_unslash( $_GET['page'] ) ) : null; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

if ( null !== $get_page && strpos( $get_page, 'seedprod' ) !== false ) {
	add_action( 'admin_print_scripts', 'seedprod_lite_disable_admin_notices' );
}

/**
 * Generate plugin nonce.
 *
 * @return void
 */
function seedprod_lite_plugin_nonce() {
	check_ajax_referer( 'seedprod_lite_plugin_nonce', 'nonce' );

	if ( ! current_user_can( 'install_plugins' ) ) {
		wp_send_json_error();
	}

	$plugin = ! empty( $_POST['plugin'] ) ? sanitize_text_field( wp_unslash( $_POST['plugin'] ) ) : null;

	$install_plugin_nonce = wp_create_nonce( 'install-plugin_' . sanitize_text_field( $plugin ) );

	wp_send_json( $install_plugin_nonce );
}

/**
 * Check if is dev URL.
 *
 * @param string $url URL being analysed.
 * @return boolean $is_local_url Return true/false whether the URL is from a dev env or not.
 */
function seedprod_lite_is_dev_url( $url = '' ) {
	$is_local_url = false;
	// Trim it up
	$url = strtolower( trim( $url ) );
	// Need to get the host...so let's add the scheme so we can use parse_url
	if ( false === strpos( $url, 'http://' ) && false === strpos( $url, 'https://' ) ) {
		$url = 'http://' . $url;
	}
	$url_parts = wp_parse_url( $url );
	$host      = ! empty( $url_parts['host'] ) ? $url_parts['host'] : false;
	if ( ! empty( $url ) && ! empty( $host ) ) {
		if ( false !== ip2long( $host ) ) {
			if ( ! filter_var( $host, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE ) ) {
				$is_local_url = true;
			}
		} elseif ( 'localhost' === $host ) {
			$is_local_url = true;
		}

		$tlds_to_check = array( '.local', ':8888', ':8080', ':8081', '.invalid', '.example', '.test' );
		foreach ( $tlds_to_check as $tld ) {
			if ( false !== strpos( $host, $tld ) ) {
				$is_local_url = true;
				break;
			}
		}
		if ( substr_count( $host, '.' ) > 1 ) {
			$subdomains_to_check = array( 'dev.', '*.staging.', 'beta.', 'test.' );
			foreach ( $subdomains_to_check as $subdomain ) {
				$subdomain = str_replace( '.', '(.)', $subdomain );
				$subdomain = str_replace( array( '*', '(.)' ), '(.*)', $subdomain );
				if ( preg_match( '/^(' . $subdomain . ')/', $host ) ) {
					$is_local_url = true;
					break;
				}
			}
		}
	}
	return $is_local_url;
}

/**
 * Find fonts in doc.
 *
 * @param Array/Object $some_array An array/object containing possible fonts in the doc.
 * @return array An array with fonts in the doc.
 */
function seedprod_lite_find_fonts_in_doc( $some_array ) {
	if ( empty( $some_array ) ) {
		return false;
	}
	$load_fonts    = array();
	$load_variants = array();
	$iterator      = new RecursiveIteratorIterator( new RecursiveArrayIterator( $some_array ), RecursiveIteratorIterator::SELF_FIRST );
	foreach ( $iterator as $k => $v ) {
		$indent = str_repeat( '&nbsp;', 10 * $iterator->getDepth() );

		// Not at end: show key only
		// if ( $iterator->callHasChildren() ) {
		// 	//echo "$indent$k :<br>";
		// 	// At end: show key, value and path
		// }

		if ( ! $iterator->callHasChildren() ) {
			for ( $p = array(), $i = 0, $z = $iterator->getDepth(); $i <= $z; $i++ ) {
				$p[] = $iterator->getSubIterator( $i )->key();
			}
			$path = implode( ',', $p );
			//echo "$indent$k : $v : path -> $path<br>";
			// get font
			if ( stripos( $k, 'font' ) !== false && stripos( $k, 'variant' ) === false && ! empty( $v ) && strpos( $v, ',' ) === false && stripos( $k, 'fontSize' ) === false ) {
				$load_fonts[] = array(
					'k' => $k,
					'v' => $v,
					'p' => $path,
				);
			}
			// get variant
			if ( stripos( $k, 'font' ) !== false && stripos( $k, 'variant' ) !== false && ! empty( $v ) && strpos( $v, ',' ) === false ) {
				$load_variants[] = array(
					'k' => $k,
					'v' => $v,
					'p' => $path,
				);
			}
		}
	}
	return array_merge( $load_fonts, $load_variants );
}

/**
 * Construct font string.
 *
 * @param array $doc_settings Array of fonts in the doc.
 * @return string $google_fonts_str Google fonts string.
 */
function seedprod_lite_construct_font_str( $doc_settings ) {
	$fonts      = seedprod_lite_find_fonts_in_doc( $doc_settings );
	$myfonts    = array();
	$myvariants = array();
	if ( ! empty( $fonts ) ) {
		foreach ( $fonts as $k => $v ) {
			if ( stripos( $v['k'], 'font' ) !== false && stripos( $v['k'], 'variant' ) === false ) {
				if ( empty( $myfonts[ $v['v'] ] ) ) {
					$myfonts[ $v['v'] ] = array();
				}

				foreach ( $fonts as $k2 => $v2 ) {
					if ( $v['p'] . 'Variant' === $v2['p'] ) {
						$myfonts[ $v['v'] ][] = $v2['v'];
					}
				}
			}
		}

		foreach ( $myfonts as $k3 => $v3 ) {
			$myfonts[ $k3 ] = array_unique( $v3 );
		}
	}
	$google_fonts_str = '';
	if ( ! empty( $myfonts ) ) {
		$google_fonts_str = 'https://fonts.googleapis.com/css?family=';
		$c                = 1;
		foreach ( $myfonts as $k4 => $v4 ) {
			$end = '|';
			if ( count( $myfonts ) == $c ) {
				$end = '';
			}
			$google_fonts_str .= urlencode( $k4 ); // phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.urlencode_urlencode
			if ( ! empty( $v4 ) ) {
				$google_fonts_str .= ':' . implode( ',', $v4 );
			}

			$google_fonts_str .= $end;
			$c++;
		}
		$google_fonts_str .= '&display=swap';
	}
	return $google_fonts_str;
}

add_filter( '_wp_post_revision_fields', 'seedprod_lite_wp_post_revision_fields', 11, 2 );

/**
 * WP Post revision fields.
 *
 * @param array $fields List of fields to revision. Contains 'post_title', 'post_content', and 'post_excerpt' by default.
 * @param array $post   A post array being processed for insertion as a post revision.
 * @return array $fields List of fields after revision.
 */
function seedprod_lite_wp_post_revision_fields( $fields, $post ) {
	if ( ! empty( $post['post_content_filtered'] ) && strpos( $post['post_content'], 'sp-page' ) !== false ) {
		$fields['post_content_filtered'] = 'Content Filtered';
		return $fields;
	} elseif ( ( ! empty( $post['post_content_filtered'] ) && strpos( $post['post_content'], 'sp-theme-template' ) !== false ) || strpos( $post['post_title'], 'Global CSS' ) !== false ) {
		$fields['post_content_filtered'] = 'Content Filtered';
		return $fields;
	} elseif ( ! empty( $post['post_content_filtered'] ) && $post['post_type'] == 'seedprod' ) {
		$fields['post_content_filtered'] = 'Content Filtered';
		return $fields;
	}else {
		return $fields;
	}
}

//add_filter( 'get_edit_post_link', 'seedprod_lite_filter_get_edit_post_link', 11, 3 );

/**
 * Get edit post link.
 *
 * @param string          $link    Link(depreciated).
 * @param integer|WP_Post $id      Post ID or post object. Default is the global $post.
 * @param string          $context How to output the '&' character. Default '&'.
 * @return string|null $link The edit post link for the given post.
 */
function seedprod_lite_filter_get_edit_post_link( $link, $id, $context ) {
	$has_settings = get_post_meta( $id, '_seedprod_page', true );
	if ( ! empty( $has_settings ) ) {
		$link = admin_url() . 'admin.php?page=seedprod_lite_builder&id=' . $id . '#/setup/' . $id;
	}
	return $link;
}

/**
 * Dismiss Settings Lite CTA
 */
function seedprod_lite_dismiss_settings_lite_cta() {
	if ( check_ajax_referer( 'seedprod_lite_dismiss_settings_lite_cta' ) ) {
		if ( ! empty( $_POST['dismiss'] ) ) {
			update_option( 'seedprod_dismiss_settings_lite_cta', true );

			$response = array(
				'status' => 'true',

			);
		}

		// Send Response
		wp_send_json( $response );
		exit;
	}
}

/**
 * Dismiss Lite Banners
 */
function seedprod_lite_dismiss_upsell() {
	if ( check_ajax_referer( 'seedprod_lite_dismiss_upsell' ) ) {
		if ( ! empty( $_POST['id'] ) ) {
			$ts = time();
			update_option( 'seedprod_dismiss_upsell_' . absint( $_POST['id'] ), $ts );
			$response = array(
				'status' => 'true',

			);
		}

		// Send Response
		wp_send_json( $response );
		exit;
	}
}

/**
 * Get expire times
 *
 * @return array Expire times.
 */
function seedprod_lite_get_expire_times() {
	return array(
		'1'    => '1 Hour',
		'2'    => '2 Hours',
		'3'    => '3 Hours',
		'4'    => '4 Hours',
		'5'    => '5 Hours',
		'6'    => '6 Hours',
		'7'    => '7 Hours',
		'8'    => '8 Hours',
		'9'    => '9 Hours',
		'10'   => '10 Hours',
		'11'   => '11 Hours',
		'12'   => '12 Hours',
		'13'   => '13 Hours',
		'14'   => '14 Hours',
		'15'   => '15 Hours',
		'16'   => '16 Hours',
		'17'   => '17 Hours',
		'18'   => '18 Hours',
		'19'   => '19 Hours',
		'20'   => '20 Hours',
		'21'   => '21 Hours',
		'21'   => '22 Hours',
		'23'   => '23 Hours',
		'24'   => '1 Day',
		'48'   => '2 Days',
		'72'   => '3 Days',
		'96'   => '4 Days',
		'120'  => '5 Days',
		'144'  => '6 Days',
		'168'  => '7 Days',
		'192'  => '8 Days',
		'216'  => '9 Days',
		'240'  => '10 Days',
		'264'  => '11 Days',
		'288'  => '12 Days',
		'312'  => '13 Days',
		'336'  => '14 Days',
		'360'  => '15 Days',
		'384'  => '16 Days',
		'408'  => '17 Days',
		'432'  => '18 Days',
		'456'  => '19 Days',
		'480'  => '20 Days',
		'504'  => '21 Days',
		'528'  => '22 Days',
		'552'  => '23 Days',
		'576'  => '24 Days',
		'600'  => '25 Days',
		'624'  => '26 Days',
		'648'  => '27 Days',
		'672'  => '28 Days',
		'696'  => '29 Days',
		'720'  => '30 Days',
		'8760' => '1 Year',
	);
}



/**
 * Get system info.
 *
 * @return string $return String with all the system info appended.
 */
function seedprod_lite_get_system_info() {
	global $wpdb;

	// Get theme info.
	$theme_data = wp_get_theme();
	$theme      = $theme_data->Name . ' ' . $theme_data->Version; //phpcs:ignore WordPress.NamingConventions.ValidVariableName.UsedPropertyNotSnakeCase

	$return = '### Begin System Info ###' . "\n\n";

	// WPForms info.
	$return .= '-- SeedProd Info' . "\n\n";

	// Now the basics...
	$return .= "\n" . '-- Site Info' . "\n\n";
	$return .= 'Site URL:                 ' . site_url() . "\n";
	$return .= 'Home URL:                 ' . home_url() . "\n";
	$return .= 'Multisite:                ' . ( is_multisite() ? 'Yes' : 'No' ) . "\n";

	// WordPress configuration.
	$return .= "\n" . '-- WordPress Configuration' . "\n\n";
	$return .= 'Version:                  ' . get_bloginfo( 'version' ) . "\n";
	$return .= 'Language:                 ' . ( defined( 'WPLANG' ) && WPLANG ? WPLANG : 'en_US' ) . "\n";
	$return .= 'Permalink Structure:      ' . ( get_option( 'permalink_structure' ) ? get_option( 'permalink_structure' ) : 'Default' ) . "\n";
	$return .= 'Active Theme:             ' . $theme . "\n";
	$return .= 'Show On Front:            ' . get_option( 'show_on_front' ) . "\n";
	// Only show page specs if front page is set to 'page'.
	if ( get_option( 'show_on_front' ) === 'page' ) {
		$front_page_id = get_option( 'page_on_front' );
		$blog_page_id  = get_option( 'page_for_posts' );

		$return .= 'Page On Front:            ' . ( 0 != $front_page_id ? get_the_title( $front_page_id ) . ' (#' . $front_page_id . ')' : 'Unset' ) . "\n";
		$return .= 'Page For Posts:           ' . ( 0 != $blog_page_id ? get_the_title( $blog_page_id ) . ' (#' . $blog_page_id . ')' : 'Unset' ) . "\n";
	}
	$return .= 'ABSPATH:                  ' . ABSPATH . "\n";
	$return .= 'Table Prefix:             Length: ' . strlen( $wpdb->prefix ) . '   Status: ' . ( strlen( $wpdb->prefix ) > 16 ? 'ERROR: Too long' : 'Acceptable' ) . "\n";
	$return .= 'WP_DEBUG:                 ' . ( defined( 'WP_DEBUG' ) ? WP_DEBUG ? 'Enabled' : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'Memory Limit:             ' . WP_MEMORY_LIMIT . "\n";
	$return .= 'Registered Post Stati:    ' . implode( ', ', get_post_stati() ) . "\n";

	// @todo WPForms configuration/specific details.
	$return .= "\n" . '-- WordPress Uploads/Constants' . "\n\n";
	$return .= 'WP_CONTENT_DIR:           ' . ( defined( 'WP_CONTENT_DIR' ) ? WP_CONTENT_DIR ? WP_CONTENT_DIR : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'WP_CONTENT_URL:           ' . ( defined( 'WP_CONTENT_URL' ) ? WP_CONTENT_URL ? WP_CONTENT_URL : 'Disabled' : 'Not set' ) . "\n";
	$return .= 'UPLOADS:                  ' . ( defined( 'UPLOADS' ) ? UPLOADS ? UPLOADS : 'Disabled' : 'Not set' ) . "\n";

	$uploads_dir = wp_upload_dir();

	$return .= 'wp_uploads_dir() path:    ' . $uploads_dir['path'] . "\n";
	$return .= 'wp_uploads_dir() url:     ' . $uploads_dir['url'] . "\n";
	$return .= 'wp_uploads_dir() basedir: ' . $uploads_dir['basedir'] . "\n";
	$return .= 'wp_uploads_dir() baseurl: ' . $uploads_dir['baseurl'] . "\n";

	// Get plugins that have an update.
	$updates = get_plugin_updates();

	// Must-use plugins.
	// NOTE: MU plugins can't show updates!
	$muplugins = get_mu_plugins();
	if ( count( $muplugins ) > 0 && ! empty( $muplugins ) ) {
		$return .= "\n" . '-- Must-Use Plugins' . "\n\n";

		foreach ( $muplugins as $plugin => $plugin_data ) {
			$return .= $plugin_data['Name'] . ': ' . $plugin_data['Version'] . "\n";
		}
	}

	// WordPress active plugins.
	$return .= "\n" . '-- WordPress Active Plugins' . "\n\n";

	$plugins        = get_plugins();
	$active_plugins = get_option( 'active_plugins', array() );

	foreach ( $plugins as $plugin_path => $plugin ) {
		if ( ! in_array( $plugin_path, $active_plugins, true ) ) {
			continue;
		}
		$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	// WordPress inactive plugins.
	$return .= "\n" . '-- WordPress Inactive Plugins' . "\n\n";

	foreach ( $plugins as $plugin_path => $plugin ) {
		if ( in_array( $plugin_path, $active_plugins, true ) ) {
			continue;
		}
		$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
		$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
	}

	if ( is_multisite() ) {
		// WordPress Multisite active plugins.
		$return .= "\n" . '-- Network Active Plugins' . "\n\n";

		$plugins        = wp_get_active_network_plugins();
		$active_plugins = get_site_option( 'active_sitewide_plugins', array() );

		foreach ( $plugins as $plugin_path ) {
			$plugin_base = plugin_basename( $plugin_path );
			if ( ! array_key_exists( $plugin_base, $active_plugins ) ) {
				continue;
			}
			$update  = ( array_key_exists( $plugin_path, $updates ) ) ? ' (needs update - ' . $updates[ $plugin_path ]->update->new_version . ')' : '';
			$plugin  = get_plugin_data( $plugin_path );
			$return .= $plugin['Name'] . ': ' . $plugin['Version'] . $update . "\n";
		}
	}

	// Server configuration (really just versions).
	$server_version = ! empty( $_SERVER['SERVER_SOFTWARE'] ) ? sanitize_text_field( wp_unslash( $_SERVER['SERVER_SOFTWARE'] ) ) : '';
	$return        .= "\n" . '-- Webserver Configuration' . "\n\n";
	$return        .= 'PHP Version:              ' . PHP_VERSION . "\n";
	$return        .= 'MySQL Version:            ' . $wpdb->db_version() . "\n";
	$return        .= 'Webserver Info:           ' . $server_version . "\n";

	// PHP configs... now we're getting to the important stuff.
	$return .= "\n" . '-- PHP Configuration' . "\n\n";
	$return .= 'Memory Limit:             ' . ini_get( 'memory_limit' ) . "\n";
	$return .= 'Upload Max Size:          ' . ini_get( 'upload_max_filesize' ) . "\n";
	$return .= 'Post Max Size:            ' . ini_get( 'post_max_size' ) . "\n";
	$return .= 'Upload Max Filesize:      ' . ini_get( 'upload_max_filesize' ) . "\n";
	$return .= 'Time Limit:               ' . ini_get( 'max_execution_time' ) . "\n";
	$return .= 'Max Input Vars:           ' . ini_get( 'max_input_vars' ) . "\n";
	$return .= 'Display Errors:           ' . ( ini_get( 'display_errors' ) ? 'On (' . ini_get( 'display_errors' ) . ')' : 'N/A' ) . "\n";

	// PHP extensions and such.
	$return .= "\n" . '-- PHP Extensions' . "\n\n";
	$return .= 'cURL:                     ' . ( function_exists( 'curl_init' ) ? 'Supported' : 'Not Supported' ) . "\n";
	$return .= 'fsockopen:                ' . ( function_exists( 'fsockopen' ) ? 'Supported' : 'Not Supported' ) . "\n";
	$return .= 'SOAP Client:              ' . ( class_exists( 'SoapClient', false ) ? 'Installed' : 'Not Installed' ) . "\n";
	$return .= 'Suhosin:                  ' . ( extension_loaded( 'suhosin' ) ? 'Installed' : 'Not Installed' ) . "\n";

	// Session stuff.
	$return .= "\n" . '-- Session Configuration' . "\n\n";
	$return .= 'Session:                  ' . ( isset( $_SESSION ) ? 'Enabled' : 'Disabled' ) . "\n";

	// The rest of this is only relevant if session is enabled.
	if ( isset( $_SESSION ) ) {
		$return .= 'Session Name:             ' . esc_html( ini_get( 'session.name' ) ) . "\n";
		$return .= 'Cookie Path:              ' . esc_html( ini_get( 'session.cookie_path' ) ) . "\n";
		$return .= 'Save Path:                ' . esc_html( ini_get( 'session.save_path' ) ) . "\n";
		$return .= 'Use Cookies:              ' . ( ini_get( 'session.use_cookies' ) ? 'On' : 'Off' ) . "\n";
		$return .= 'Use Only Cookies:         ' . ( ini_get( 'session.use_only_cookies' ) ? 'On' : 'Off' ) . "\n";
	}

	$return .= "\n" . '### End System Info ###';

	return $return;
}

/**
 * If site uses WP Rocket, disable minify for CSS & JS
 */
function seedprod_lite_wprocket_disable_minify() {
	if ( function_exists( 'rocket_define_donotminify_constant' ) ) {
		rocket_define_donotminify_constant( 'true' );
	}
}




