<?php
if (function_exists('vc_map_get_attributes')) {						// New VC
	/**
	 * Shortcode attributes
	 * @var $scheme		- added by Charity Is Hope
	 * @var $inverse	- added by Charity Is Hope
	 * @var $atts
	 * @var $el_class
	 * @var $full_width
	 * @var $full_height
	 * @var $content_placement
	 * @var $parallax
	 * @var $parallax_image
	 * @var $css
	 * @var $el_id
	 * @var $video_bg
	 * @var $video_bg_url
	 * @var $video_bg_parallax
	 * @var $content - shortcode content
	 * Shortcode class
	 * @var $this WPBakeryShortCode_VC_Row
	 */
	$output = $after_output = '';
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
	extract( $atts );
	
	wp_enqueue_script( 'wpb_composer_front_js' );
	
	$el_class = $this->getExtraClass( $el_class );

	if ( isset($disable_element) and ( $disable_element === 'yes' ) ) {
		return '';
	}

	$css_classes = array(
		'vc_row',
		'wpb_row', //deprecated
		'vc_row-fluid',
		$el_class,
		vc_shortcode_custom_css_class( $css ),
	);
	
	// Added by Charity Is Hope:
	// Color scheme
	if ($scheme && !charity_is_hope_param_is_off($scheme) && !charity_is_hope_param_is_inherit($scheme)) $css_classes[] = 'scheme_'.esc_attr($scheme);
	// Inverse colors
	if ($inverse && !charity_is_hope_param_is_off($inverse)) $css_classes[] = 'inverse_colors';
	
	$wrapper_attributes = array();
	// build attributes for wrapper
	if ( ! empty( $el_id ) ) {
		$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
	}
	if ( ! empty( $full_width ) ) {
		$wrapper_attributes[] = 'data-vc-full-width="true"';
		$wrapper_attributes[] = 'data-vc-full-width-init="false"';
		if ( 'stretch_row_content' === $full_width ) {
			$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
			$wrapper_attributes[] = 'data-vc-stretch-content="true"';
			$css_classes[] = 'vc_row-no-padding';
		}
		$after_output .= '<div class="vc_row-full-width"></div>';
	}
	
	if ( ! empty( $full_height ) ) {
		$css_classes[] = ' vc_row-o-full-height';
		if ( ! empty( $content_placement ) ) {
			$css_classes[] = ' vc_row-o-content-' . esc_attr($content_placement);
		}
	}
	
	// use default video if user checked video, but didn't chose url
	if ( ! empty( $video_bg ) && empty( $video_bg_url ) ) {
		$video_bg_url = 'https://www.youtube.com/watch?v=lMJXxhRFO1k';
	}
	
	$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );
	
	if ( $has_video_bg ) {
		$parallax = $video_bg_parallax;
		$parallax_image = $video_bg_url;
		$css_classes[] = ' vc_video-bg-container';
		wp_enqueue_script( 'vc_youtube_iframe_api_js' );
	}
	
	if ( ! empty( $parallax ) ) {
		wp_enqueue_script( 'vc_jquery_skrollr_js' );
		$wrapper_attributes[] = 'data-vc-parallax="1.5"'; // parallax speed
		$css_classes[] = 'vc_general vc_parallax vc_parallax-' . esc_attr($parallax);
		if ( strpos( $parallax, 'fade' ) !== false ) {
			$css_classes[] = 'js-vc_parallax-o-fade';
			$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
		} elseif ( strpos( $parallax, 'fixed' ) !== false ) {
			$css_classes[] = 'js-vc_parallax-o-fixed';
		}
	}
	
	if ( ! empty ( $parallax_image ) ) {
		if ( $has_video_bg ) {
			$parallax_image_src = $parallax_image;
		} else {
			$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
			$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
			if ( ! empty( $parallax_image_src[0] ) ) {
				$parallax_image_src = $parallax_image_src[0];
			}
		}
		$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
	}
	if ( ! $parallax && $has_video_bg ) {
		$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
	}
	$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
	$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';
	
	$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
	$output .= wpb_js_remove_wpautop( $content );
	$output .= '</div>';
	$output .= $after_output;
	$output .= $this->endBlockComment( $this->getShortcode() );

	charity_is_hope_show_layout($output);

} else {																		// Old VC
	
	/** @var $this WPBakeryShortCode_VC_Row */
	$output = $el_class = $bg_image = $bg_color = $bg_image_repeat = $font_color = $padding = $margin_bottom = $css = $full_width = '';
	extract( shortcode_atts( array(
		'el_class' => '',
		'bg_image' => '',
		'bg_color' => '',
		'bg_image_repeat' => '',
		'font_color' => '',
		'padding' => '',
		'margin_bottom' => '',
		'full_width' => false,
		'css' => '',
	), $atts ) );
	
	$el_class = $this->getExtraClass( $el_class );
	$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'vc_row wpb_row ' . ( $this->settings( 'base' ) === 'vc_row_inner' ? 'vc_inner ' : '' ) . get_row_css_class() . $el_class . vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );
	
	// Add Charity Is Hope color scheme in the row
	if ($scheme && !charity_is_hope_param_is_off($scheme) && !charity_is_hope_param_is_inherit($scheme)) $css_class .= ' scheme_'.esc_attr($scheme);
	
	$style = $this->buildStyle( $bg_image, $bg_color, $bg_image_repeat, $font_color, $padding, $margin_bottom );
	?>
		<div <?php
		?>class="<?php echo esc_attr( $css_class ); ?><?php if ( $full_width == 'stretch_row_content_no_spaces' ): echo ' vc_row-no-padding'; endif; ?>" <?php if ( ! empty( $full_width ) ) {
		echo ' data-vc-full-width="true"';
		if ( $full_width == 'stretch_row_content' || $full_width == 'stretch_row_content_no_spaces' ) {
			echo ' data-vc-stretch-content="true"';
		}
	} ?> <?php charity_is_hope_show_layout($style); ?>><?php
	echo wpb_js_remove_wpautop( $content );
	?></div><?php charity_is_hope_show_layout($this->endBlockComment('row'));
	if ( ! empty( $full_width ) ) {
		echo '<div class="vc_row-full-width"></div>';
	}
}
?>