<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_moove
 * @copyright 2017 Willian Mano - http://conecti.me
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Moove';
$string['configtitle'] = 'Moove';
$string['choosereadme'] = 'Moove is a modern highly-customisable theme. This theme is intended to be used directly, or as a parent theme when creating new themes utilising Bootstrap 4.';

$string['currentinparentheses'] = '(current)';
$string['region-side-pre'] = 'Right';
$string['login'] = 'Already have an account?';
$string['prev_section'] = 'Previous section';
$string['next_section'] = 'Next section';
$string['search_site'] = 'Search on site';
$string['search_forums'] = 'Search on course forums';
$string['platform_access'] = 'Access to the platform';
$string['readmore'] = 'Read More';
$string['stayintouch'] = 'Contact us';
$string['madewitmoodle'] = 'Proudly made with';
$string['madeby'] = 'Made with';
$string['by'] = 'by';
$string['discipline_progress'] = 'Topic\'s progress';
$string['access'] = 'Access';
$string['cachedef_admininfos'] = 'Site administrator dashboard infos';
$string['diskusage'] = 'Disk usage(moodledata)';
$string['notcalculatedyet'] = 'Not calculated yet';
$string['calculatediskusagetask'] = 'Taks to calculate the disk usage';
$string['totalusers'] = 'Active / Suspended users';
$string['totalcourses'] = 'Total courses';
$string['onlineusers'] = 'Online users(last 5 minutes)';
$string['showhideblocks'] = 'Show/hide blocks';
$string['prev_activity'] = 'Previous activity';
$string['next_activity'] = 'Next activity';

// General settings tab.
$string['generalsettings'] = 'General';
$string['logo'] = 'Logo';
$string['logodesc'] = 'The logo is displayed in the header.';
$string['favicon'] = 'Custom favicon';
$string['favicondesc'] = 'Upload your own favicon.  It should be an .ico file.';
$string['preset'] = 'Theme preset';
$string['preset_desc'] = 'Pick a preset to broadly change the look of the theme.';
$string['presetfiles'] = 'Additional theme preset files';
$string['presetfiles_desc'] = 'Preset files can be used to dramatically alter the appearance of the theme. See <a href="https://docs.moodle.org/dev/Boost_Presets">Boost presets</a> for information on creating and sharing your own preset files.';
$string['loginbgimg'] = 'Login page background';
$string['loginbgimg_desc'] = 'Upload your custom background image for the login page.';
$string['brandcolor'] = 'Brand colour';
$string['brandcolor_desc'] = 'The accent colour.';
$string['navbarheadercolor'] = 'Navbar header color';
$string['navbarheadercolor_desc'] = 'The top navbar header color';
$string['navbarbg'] = 'Navbar color';
$string['navbarbg_desc'] = 'The left navbar color';
$string['navbarbghover'] = 'Navbar hover color';
$string['navbarbghover_desc'] = 'The left navbar hover color';
$string['coursepresentation'] = 'Course presentation';
$string['coursepresentationdesc'] = '<b>Default presentation:</b> The default course appearence.<br><b>Cover image:</b> Will be showed a cover image on the top of the course page(the first image in course summary files will be used).';
$string['coursedefault'] = 'Default presentation';
$string['coursecover'] = 'Cover image';
$string['courselistview'] = 'Enable course list view';
$string['courselistviewdesc'] = 'Switch the courses view from box to list view';

// Advanced settings tab.
$string['advancedsettings'] = 'Advanced';
$string['rawscsspre'] = 'Raw initial SCSS';
$string['rawscsspre_desc'] = 'In this field you can provide initialising SCSS code, it will be injected before everything else. Most of the time you will use this setting to define variables.';
$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code which will be injected at the end of the style sheet.';
$string['googleanalytics'] = 'Google Analytics Code';
$string['googleanalyticsdesc'] = 'Please enter your Google Analytics code to enable analytics on your website. The code format shold be like [UA-XXXXX-Y]';

// Frontpage settings tab.
$string['frontpagesettings'] = 'Frontpage';
$string['disablefrontpageloginbox'] = 'Disable frontpage login box';
$string['disablefrontpageloginboxdesc'] = 'If you check it, the frontpage login box will be hidden and a link to the login page will be printed in the header bar.';
$string['headerimg'] = 'Header image';
$string['headerimgdesc'] = 'Upload your custom header-image here if you want to add it to the header.mage works best if (Image size should be 1500px x 700px)';
$string['bannerheading'] = 'Banner Heading';
$string['bannerheadingdesc'] = 'Enter Banner Heading Text';
$string['bannercontent'] = 'Banner Content';
$string['bannercontentdesc'] = 'Enter Banner Content Text';
$string['displaymarketingbox'] = 'Display front page Marketingbox';
$string['displaymarketingboxdesc'] = 'Show or Hide Front page Marketingbox';
$string['marketing1icon'] = 'Marketing1 Icon';
$string['marketing1icondesc'] = 'Upload Marketing1 Icon';
$string['marketing1heading'] = 'Marketing1 Heading';
$string['marketing1headingdesc'] = 'Enter Marketing1 Heading Text';
$string['marketing1subheading'] = 'Marketing1 Subheading';
$string['marketing1subheadingdesc'] = 'Enter Marketing1 Subheading Text';
$string['marketing1content'] = 'Marketing1 Content';
$string['marketing1contentdesc'] = 'Enter Marketing1 Content Text';
$string['marketing1url'] = 'Marketing1 URL';
$string['marketing1urldesc'] = 'Enter Marketing1 URL';
$string['marketing2icon'] = 'Marketing2 Icon';
$string['marketing2icondesc'] = 'Upload Marketing2 Icon';
$string['marketing2heading'] = 'Marketing2 Heading';
$string['marketing2headingdesc'] = 'Enter Marketing2 Heading Text';
$string['marketing2subheading'] = 'Marketing2 Subheading';
$string['marketing2subheadingdesc'] = 'Enter Marketing2 Subheading Text';
$string['marketing2content'] = 'Marketing2 Content';
$string['marketing2contentdesc'] = 'Enter Marketing2 Content Text';
$string['marketing2url'] = 'Marketing2 URL';
$string['marketing2urldesc'] = 'Enter Marketing2 URL';
$string['marketing3icon'] = 'Marketing3 Icon';
$string['marketing3icondesc'] = 'Upload Marketing3 Icon';
$string['marketing3heading'] = 'Marketing3 Heading';
$string['marketing3headingdesc'] = 'Enter Marketing3 Heading Text';
$string['marketing3subheading'] = 'Marketing3 Subheading';
$string['marketing3subheadingdesc'] = 'Enter Marketing3 Subheading Text';
$string['marketing3content'] = 'Marketing3 Content';
$string['marketing3contentdesc'] = 'Enter Marketing3 Content Text';
$string['marketing3url'] = 'Marketing3 URL';
$string['marketing3urldesc'] = 'Enter Marketing3 URL';
$string['marketing4icon'] = 'Marketing4 Icon';
$string['marketing4icondesc'] = 'Upload Marketing4 Icon';
$string['marketing4heading'] = 'Marketing4 Heading';
$string['marketing4headingdesc'] = 'Enter Marketing4 Heading Text';
$string['marketing4subheading'] = 'Marketing4 Subheading';
$string['marketing4subheadingdesc'] = 'Enter Marketing4 Subheading Text';
$string['marketing4content'] = 'Marketing4 Content';
$string['marketing4contentdesc'] = 'Enter Marketing4 Content Text';
$string['marketing4url'] = 'Marketing4 URL';
$string['marketing4urldesc'] = 'Enter Marketing4 URL';
$string['disableteacherspic'] = 'Disable teachers picture';
$string['disableteacherspicdesc'] = 'This setting hides the teachers\' pictures from the course cards.';

$string['sliderenabled'] = 'Enable slider';
$string['sliderenableddesc'] = 'Enable a slider at the top of your home page';
$string['sliderfrontpage'] = 'Show slideshow in frontpage';
$string['sliderfrontpagedesc'] = 'If enabled, the slideshow will be showed in the frontpage page replacing the header image.';
$string['slidercount'] = 'Slider count';
$string['slidercountdesc'] = 'Select how many slides you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['sliderimage'] = 'Slider picture';
$string['sliderimagedesc'] = 'Add an image for your slide. Recommended size is 1500px x 540px or higher.';
$string['slidertitle'] = 'Slide title';
$string['slidertitledesc'] = 'Add the slide\'s title.';
$string['slidercaption'] = 'Slider caption';
$string['slidercaptiondesc'] = 'Add a caption for your slide';

$string['numbersfrontpage'] = 'Show site numbers on frontpage';
$string['numbersfrontpagedesc'] = 'If enabled, display the number of active users, courses and activities in the frontpage.';
$string['frontpagenumbersome'] = 'Some';
$string['frontpagenumbernumbers'] = 'Numbers';
$string['frontpagenumberusers'] = 'Users';
$string['frontpagenumbercourses'] = 'Courses';
$string['frontpagenumberactivities'] = 'Activities';

$string['sponsorstitledefault'] = 'Sponsors';
$string['sponsorssubtitledefault'] = 'Companies and institutions that believe in us';
$string['sponsorsfrontpage'] = 'Enable sponsors row';
$string['sponsorsfrontpagedesc'] = 'If enabled, display a row with the sponsors logos with its urls.';
$string['sponsorstitle'] = 'Sponsors title';
$string['sponsorstitledesc'] = 'The header of the sponsors row.';
$string['sponsorssubtitle'] = 'Sponsors subtitle';
$string['sponsorssubtitledesc'] = 'The subtitle of the sponsors row.';
$string['sponsorscount'] = 'Sponsors count';
$string['sponsorscountdesc'] = 'Select how many sponsor\'s logos you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['sponsorsimage'] = 'Sponsor logo';
$string['sponsorsimagedesc'] = 'Add the sponsor\'s logo.';
$string['sponsorsurl'] = 'Sponsor URL';
$string['sponsorsurldesc'] = 'Enter the sponsor\'s site URL';

$string['clientstitledefault'] = 'Our clients';
$string['clientssubtitledefault'] = 'Clients that believe in us';
$string['clientsfrontpage'] = 'Enable clients row';
$string['clientsfrontpagedesc'] = 'If enabled, display a row with the clients logos with its urls.';
$string['clientstitle'] = 'Clients title';
$string['clientstitledesc'] = 'The header of the clients row.';
$string['clientssubtitle'] = 'Clients subtitle';
$string['clientssubtitledesc'] = 'The subtitle of the clients row.';
$string['clientscount'] = 'Clients count';
$string['clientscountdesc'] = 'Select how many clients\'s logos you want to add <strong>then click SAVE</strong> to load the input fields.';
$string['clientsimage'] = 'Client logo';
$string['clientsimagedesc'] = 'Add the client\'s logo.';
$string['clientsurl'] = 'Client URL';
$string['clientsurldesc'] = 'Enter the client\'s site URL';

// Footer settings tab.
$string['footersettings'] = 'Footer';
$string['getintouchcontent'] = 'Get In Touch Content';
$string['getintouchcontentdesc'] = 'Enter Get In Touch Content Text';
$string['website'] = 'Website URL';
$string['websitedesc'] = 'Main company Website';
$string['mobile'] = 'Mobile';
$string['mobiledesc'] = 'Enter Mobile No';
$string['mail'] = 'E-Mail';
$string['maildesc'] = 'Enter E-Mail ID';
$string['facebook'] = 'Facebook URL';
$string['facebookdesc'] = 'Enter the URL of your Facebook. (i.e http://www.facebook.com/moodlehq)';
$string['twitter'] = 'Twitter URL';
$string['twitterdesc'] = 'Enter the URL of your twitter. (i.e http://www.twitter.com/moodlehq)';
$string['linkedin'] = 'Linkedin URL';
$string['linkedindesc'] = 'Enter the URL of your Linkedin. (i.e http://www.linkedin.com/moodlehq)';
$string['youtube'] = 'Youtube URL';
$string['youtubedesc'] = 'Enter the URL of your Youtube. (i.e https://www.youtube.com/user/moodlehq)';
$string['instagram'] = 'Instagram URL';
$string['instagramdesc'] = 'Enter the URL of your Instagram. (i.e https://www.instagram.com/moodlehq)';
$string['whatsapp'] = 'Whatsapp number';
$string['whatsappdesc'] = 'Enter your whatsapp number for contact.';
$string['topfooterimg'] = 'Footer image';
$string['topfooterimgdesc'] = 'Upload your custom footer image here if you want to replace the default image. Recommended size is 1500px x 400px or higher.';
$string['disablebottomfooter'] = 'Disable bottom footer';
$string['disablebottomfooterdesc'] = 'Disables the orange bottom footer';

// Forum.
$string['forumsettings'] = 'Forum';
$string['forumsettingsdesc'] = 'Configure the general forum settings for the theme here.';
$string['forumhtmlemailheader'] = 'Email header';
$string['forumhtmlemailheaderdesc'] = 'Configure the email header for the forum messages.';
$string['forumhtmlemailfooter'] = 'Email footer';
$string['forumhtmlemailfooterdesc'] = 'Configure the email footer for the forum messages.';
$string['forumcustomtemplate'] = 'Use a pretty template for forum mails';
$string['forumcustomtemplatedesc'] = 'Enable that in order to use a pretty template when sending forum messages via email. If not enabled standard formatting of forum mails will be used.';

$string['certificates'] = 'Certificates';
$string['certificatestitle'] = 'My certificates';
$string['subtitleallcertificates'] = 'Certificates from all courses';
$string['subtitlecoursecertificates'] = 'Course certificates';
$string['nohavecertificates'] = 'You no have certificates yet';
$string['coursesections'] = 'Course sections';

// Mypublic page.
$string['userprofile'] = 'User profile vvvv';
$string['competencyplans'] = 'Competency plans';
$string['details'] = 'Details';
$string['startedon'] = 'Started on';
$string['addcontact'] = 'Add contact';
$string['removecontact'] = 'Remove contact';
$string['certificates'] = 'Certificates';

// Theme settings.
$string['themesettingstitle'] = 'Accessibility settings';
$string['themesettingsfonttype'] = 'Font type';
$string['themesettingsdefaultfont'] = 'Default font';
$string['themesettingsdyslexicfont'] = 'Dyslexic font';
$string['themesettingsenableaccessibilitytoolbar'] = 'Enable accessibility toolbar';
$string['themesettinggsavedsuccessfully'] = 'Accessibility settings saved successfully';

// Accessibility features.
$string['accessibilityfontsize'] = 'Font size';
$string['accessibilitydecreasefont'] = 'Decrease font size';
$string['accessibilityresetfont'] = 'Reset font size';
$string['accessibilityincreasefont'] = 'Increase font size';
$string['accessibilitysitecolor'] = 'Site color';
$string['accessibilityresetsitecolor'] = 'Reset site color';
$string['accessibilitysitecolor2'] = 'Low contrast 1';
$string['accessibilitysitecolor3'] = 'Low contrast 2';
$string['accessibilitysitecolor4'] = 'High contrast';

// Data privacy.
$string['privacy:metadata:preference:accessibilitystyles_fontsizeclass'] = 'The user\'s preference for font size.';
$string['privacy:metadata:preference:accessibilitystyles_sitecolorclass'] = 'The user\'s preference for site color.';
$string['privacy:metadata:preference:thememoovesettings_fonttype'] = 'The user\'s preference for font type.';
$string['privacy:metadata:preference:thememoovesettings_enableaccessibilitytoolbar'] = 'The user\'s preference for enable the accessibility toolbar.';

$string['privacy:accessibilitystyles_fontsizeclass'] = 'The current preference for the font size is: {$a}.';
$string['privacy:accessibilitystyles_sitecolorclass'] = 'The current preference for the site color is: {$a}.';
$string['privacy:thememoovesettings_fonttype'] = 'The current preference for the font type is: {$a}.';
$string['privacy:thememoovesettings_enableaccessibilitytoolbar'] = 'The current preference for enable accessibility toolbar is to show it.';

//images
$string['disclaimer'] = 'https://lade-lms.org/lade-lms/theme/moove/pix/ENGDisclaimer.png';
